/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import java.io.Serializable;

public class JndiName
implements Serializable,
Comparable<JndiName> {
    private static final long serialVersionUID = 3748117883355718029L;
    private static final String ENTRY_SEPARATOR = "/";
    private final JndiName parent;
    private final String local;

    private JndiName(JndiName parent, String local) {
        this.parent = parent;
        this.local = local;
    }

    public String getLocalName() {
        return this.local;
    }

    public JndiName getParent() {
        return this.parent;
    }

    public String getAbsoluteName() {
        StringBuilder absolute = new StringBuilder();
        if (this.parent != null) {
            absolute.append(this.parent).append(ENTRY_SEPARATOR);
        }
        absolute.append(this.local);
        return absolute.toString();
    }

    public JndiName append(String local) {
        return new JndiName(this, local);
    }

    public static JndiName of(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("A valid JNDI name must be provided: " + name);
        }
        String[] parts = name.split(ENTRY_SEPARATOR);
        JndiName current = null;
        for (String part : parts) {
            current = new JndiName(current, part);
        }
        return current;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiName jndiName = (JndiName)o;
        return !(this.local == null ? jndiName.local != null : !this.local.equals(jndiName.local)) && !(this.parent == null ? jndiName.parent != null : !this.parent.equals(jndiName.parent));
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.local != null ? this.local.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getAbsoluteName();
    }

    @Override
    public int compareTo(JndiName other) {
        return this.getAbsoluteName().compareTo(other.getAbsoluteName());
    }
}

