/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx2.impl;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.tx2.impl.BMTInterceptor;
import org.jboss.ejb3.tx2.spi.TransactionalInvocationContext;
import org.jboss.logging.Logger;

public abstract class StatelessBMTInterceptor
extends BMTInterceptor {
    private static final Logger log = Logger.getLogger(StatelessBMTInterceptor.class);

    private void checkStatelessDone(TransactionalInvocationContext invocation, Exception ex) throws Exception {
        int status = 6;
        TransactionManager tm = this.getTransactionManager();
        try {
            status = tm.getStatus();
        }
        catch (SystemException sex) {
            log.error((Object)"Failed to get status", (Throwable)sex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    tm.rollback();
                }
                catch (Exception sex) {
                    log.error((Object)"Failed to rollback", (Throwable)sex);
                }
            }
            case 2: {
                String msg = "Application error: BMT stateless bean " + this.getComponentName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
                log.error((Object)msg);
                throw new EJBException(msg);
            }
        }
        if (ex != null) {
            throw this.handleException(invocation, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleInvocation(TransactionalInvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        assert (tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        boolean exceptionThrown = false;
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception ex) {
            exceptionThrown = true;
            this.checkStatelessDone(invocation, ex);
            throw ex;
        }
        finally {
            try {
                if (!exceptionThrown) {
                    this.checkStatelessDone(invocation, null);
                }
            }
            finally {
                tm.suspend();
            }
        }
    }
}

