/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import org.jboss.logging.Logger;
import org.jboss.modcluster.load.metric.impl.MBeanLoadContext;
import org.jboss.modcluster.load.metric.impl.OperatingSystemLoadMetricSource;
import org.jboss.modcluster.load.metric.impl.SourcedLoadMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageSystemLoadMetric
extends SourcedLoadMetric<MBeanLoadContext> {
    public static final String SYSTEM_LOAD_AVERAGE = "SystemLoadAverage";
    private Logger logger = Logger.getLogger(this.getClass());

    public AverageSystemLoadMetric() throws MalformedObjectNameException {
        super(new OperatingSystemLoadMetricSource());
    }

    public AverageSystemLoadMetric(OperatingSystemLoadMetricSource source) {
        super(source);
    }

    @Override
    public double getLoad(MBeanLoadContext context) throws JMException {
        try {
            return context.getAttribute(SYSTEM_LOAD_AVERAGE, Double.class);
        }
        catch (AttributeNotFoundException e) {
            this.logger.warn((Object)(this.getClass().getSimpleName() + " requires Java 1.6 or later."));
            this.setWeight(0);
            return 0.0;
        }
    }
}

