/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Connector;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ModClusterConfig;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.SimpleLoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.ContextFilter;
import org.jboss.modcluster.mcmp.MCMPConnectionListener;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequestFactory;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPResponseParser;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModClusterService
implements ModClusterServiceMBean,
ContainerEventHandler,
LoadBalanceFactorProvider,
MCMPConnectionListener,
ContextFilter {
    private static final int DEFAULT_PORT = 8000;
    protected final Logger log = Logger.getLogger(this.getClass());
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPHandlerConfiguration mcmpConfig;
    private final MCMPHandler mcmpHandler;
    private final ResetRequestSource resetRequestSource;
    private final MCMPRequestFactory requestFactory;
    private final MCMPResponseParser responseParser;
    private final AdvertiseListenerFactory listenerFactory;
    private final LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory;
    private final Map<Host, Set<String>> excludedContexts = new HashMap<Host, Set<String>>();
    private final ConcurrentMap<Context, EnablableRequestListener> requestListeners = new ConcurrentHashMap<Context, EnablableRequestListener>();
    private volatile boolean established = false;
    private volatile boolean autoEnableContexts = true;
    private volatile Server server;
    private volatile LoadBalanceFactorProvider loadBalanceFactorProvider;
    private volatile AdvertiseListener advertiseListener;

    public ModClusterService(ModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider) {
        this(config, new SimpleLoadBalanceFactorProviderFactory(loadBalanceFactorProvider));
    }

    public ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory) {
        this(config, loadBalanceFactorProviderFactory, new DefaultMCMPRequestFactory());
    }

    private ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory) {
        this(config, loadBalanceFactorProviderFactory, requestFactory, new DefaultMCMPResponseParser(), new ResetRequestSourceImpl(config, config, requestFactory));
    }

    private ModClusterService(ModClusterConfig config, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource) {
        this(config, config, config, loadBalanceFactorProviderFactory, requestFactory, responseParser, resetRequestSource, new DefaultMCMPHandler(config, resetRequestSource, requestFactory, responseParser), new AdvertiseListenerFactoryImpl());
    }

    protected ModClusterService(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource, MCMPHandler mcmpHandler, AdvertiseListenerFactory listenerFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.mcmpConfig = mcmpConfig;
        this.mcmpHandler = mcmpHandler;
        this.resetRequestSource = resetRequestSource;
        this.requestFactory = requestFactory;
        this.responseParser = responseParser;
        this.loadBalanceFactorProviderFactory = loadBalanceFactorProviderFactory;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public synchronized void init(Server server) {
        this.log.info((Object)Strings.SERVER_INIT.getString(new Object[0]));
        this.server = server;
        List<InetSocketAddress> initialProxies = Utils.parseSocketAddresses(this.mcmpConfig.getProxyList(), 8000);
        this.mcmpHandler.init(initialProxies, this);
        this.autoEnableContexts = this.mcmpConfig.isAutoEnableContexts();
        this.excludedContexts.clear();
        Map<String, Set<String>> excludedContextPaths = Utils.parseContexts(this.mcmpConfig.getExcludedContexts());
        if (!excludedContextPaths.isEmpty()) {
            for (Engine engine : server.getEngines()) {
                for (Host host : engine.getHosts()) {
                    Set<String> paths = excludedContextPaths.get(host.getName());
                    if (paths == null) continue;
                    this.excludedContexts.put(host, Collections.unmodifiableSet(paths));
                }
            }
        }
        this.resetRequestSource.init(server, this);
        this.loadBalanceFactorProvider = this.loadBalanceFactorProviderFactory.createLoadBalanceFactorProvider();
        Boolean advertise = this.mcmpConfig.getAdvertise();
        if (Boolean.TRUE.equals(advertise) || advertise == null && initialProxies.isEmpty()) {
            try {
                this.advertiseListener = this.listenerFactory.createListener(this.mcmpHandler, this.mcmpConfig);
                this.advertiseListener.start();
            }
            catch (IOException e) {
                this.log.error((Object)Strings.ERROR_ADVERTISE_START.getString(new Object[0]), (Throwable)e);
            }
        }
    }

    @Override
    public Map<Host, Set<String>> getExcludedContexts() {
        return Collections.unmodifiableMap(this.excludedContexts);
    }

    @Override
    public boolean isAutoEnableContexts() {
        return this.autoEnableContexts;
    }

    @Override
    public synchronized void shutdown() {
        this.log.debug((Object)Strings.SHUTDOWN.getString(new Object[0]));
        this.server = null;
        if (this.advertiseListener != null) {
            this.advertiseListener.destroy();
            this.advertiseListener = null;
        }
        this.mcmpHandler.shutdown();
    }

    @Override
    public void start(Server server) {
        this.log.debug((Object)Strings.SERVER_START.getString(new Object[0]));
        if (this.established) {
            for (Engine engine : server.getEngines()) {
                this.config(engine);
                for (Host host : engine.getHosts()) {
                    for (Context context : host.getContexts()) {
                        this.add(context);
                    }
                }
            }
        }
    }

    @Override
    public void stop(Server server) {
        this.log.debug((Object)Strings.SERVER_STOP.getString(new Object[0]));
        if (this.established) {
            for (Engine engine : server.getEngines()) {
                for (Host host : engine.getHosts()) {
                    for (Context context : host.getContexts()) {
                        if (context.isStarted()) {
                            this.stop(context);
                        }
                        this.remove(context);
                    }
                }
                this.removeAll(engine);
            }
        }
    }

    protected void config(Engine engine) {
        this.log.debug((Object)Strings.ENGINE_CONFIG.getString(engine));
        try {
            MCMPRequest request = this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig);
            this.mcmpHandler.sendRequest(request);
        }
        catch (Exception e) {
            this.mcmpHandler.markProxiesInError();
            this.log.info((Object)Strings.ERROR_ADDRESS_JVMROUTE.getString(new Object[0]), (Throwable)e);
        }
    }

    @Override
    public boolean isEstablished() {
        return this.established;
    }

    @Override
    public void connectionEstablished(InetAddress localAddress) {
        for (Engine engine : this.server.getEngines()) {
            Connector connector = engine.getProxyConnector();
            InetAddress address = connector.getAddress();
            if (address == null || address.isAnyLocalAddress()) {
                connector.setAddress(localAddress);
                this.log.info((Object)Strings.DETECT_CONNECTOR_ADDRESS.getString(engine, localAddress.getHostAddress()));
            }
            this.establishJvmRoute(engine);
        }
        this.established = true;
    }

    protected void establishJvmRoute(Engine engine) {
        if (engine.getJvmRoute() == null) {
            String jvmRoute = this.mcmpConfig.getJvmRouteFactory().createJvmRoute(engine);
            engine.setJvmRoute(jvmRoute);
            this.log.info((Object)Strings.DETECT_JVMROUTE.getString(engine, jvmRoute));
        }
    }

    @Override
    public void add(Context context) {
        if (this.include(context) && this.established && context.isStarted()) {
            this.log.debug((Object)Strings.CONTEXT_ENABLE.getString(context, context.getHost()));
            this.enable(context);
        }
    }

    @Override
    public void start(Context context) {
        if (this.include(context)) {
            NotifyOnDestroyRequestListener listener;
            if (this.established) {
                this.log.debug((Object)Strings.CONTEXT_START.getString(context, context.getHost()));
                this.enable(context);
            }
            if (this.requestListeners.putIfAbsent(context, listener = new NotifyOnDestroyRequestListener()) == null) {
                context.addRequestListener(listener);
            }
        }
    }

    private void enable(Context context) {
        MCMPRequest request = this.autoEnableContexts ? this.requestFactory.createEnableRequest(context) : this.requestFactory.createDisableRequest(context);
        this.mcmpHandler.sendRequest(request);
    }

    private void disable(Context context) {
        MCMPRequest request = this.requestFactory.createDisableRequest(context);
        this.mcmpHandler.sendRequest(request);
    }

    @Override
    public void stop(Context context) {
        if (this.established && this.include(context)) {
            this.log.debug((Object)Strings.CONTEXT_STOP.getString(context, context.getHost()));
            this.disable(context);
            long start = System.currentTimeMillis();
            long end = start + this.mcmpConfig.getStopContextTimeoutUnit().toMillis(this.mcmpConfig.getStopContextTimeout());
            if (this.mcmpConfig.getSessionDrainingStrategy().isEnabled(context)) {
                this.drainSessions(context, start, end);
            }
            this.drainRequests(context, start, end);
        }
    }

    @Override
    public void remove(Context context) {
        if (this.include(context)) {
            EnablableRequestListener listener;
            if (this.established) {
                this.log.debug((Object)Strings.CONTEXT_DISABLE.getString(context, context.getHost()));
                MCMPRequest request = this.requestFactory.createRemoveRequest(context);
                this.mcmpHandler.sendRequest(request);
            }
            if ((listener = (EnablableRequestListener)this.requestListeners.remove(context)) != null) {
                context.removeRequestListener(listener);
            }
        }
    }

    protected void removeAll(Engine engine) {
        this.log.debug((Object)Strings.ENGINE_STOP.getString(engine));
        MCMPRequest request = this.requestFactory.createRemoveRequest(engine);
        this.mcmpHandler.sendRequest(request);
    }

    @Override
    public void status(Engine engine) {
        this.log.debug((Object)Strings.ENGINE_STATUS.getString(engine));
        this.mcmpHandler.status();
        if (this.established) {
            Connector connector = engine.getProxyConnector();
            int lbf = -1;
            if (connector != null && connector.isAvailable()) {
                lbf = this.getLoadBalanceFactor();
            }
            this.mcmpHandler.sendRequest(this.requestFactory.createStatusRequest(engine.getJvmRoute(), lbf));
        }
    }

    private boolean include(Context context) {
        Set<String> excludedPaths = this.excludedContexts.get(context.getHost());
        return excludedPaths == null || !excludedPaths.contains(context.getPath());
    }

    @Override
    public int getLoadBalanceFactor() {
        return this.loadBalanceFactorProvider.getLoadBalanceFactor();
    }

    @Override
    public void addProxy(String host, int port) {
        this.mcmpHandler.addProxy(this.createSocketAddress(host, port));
    }

    @Override
    public void removeProxy(String host, int port) {
        this.mcmpHandler.removeProxy(this.createSocketAddress(host, port));
    }

    private InetSocketAddress createSocketAddress(String host, int port) {
        try {
            return new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.getProxyResults(this.requestFactory.createDumpRequest());
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.getProxyResults(this.requestFactory.createInfoRequest());
    }

    @Override
    public Map<InetSocketAddress, String> ping() {
        MCMPRequest request = this.requestFactory.createPingRequest();
        return this.getProxyResults(request);
    }

    @Override
    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        MCMPRequest request = this.requestFactory.createPingRequest(jvmRoute);
        return this.getProxyResults(request);
    }

    @Override
    public Map<InetSocketAddress, String> ping(String scheme, String host, int port) {
        MCMPRequest request = this.requestFactory.createPingRequest(scheme, host, port);
        return this.getProxyResults(request);
    }

    private Map<InetSocketAddress, String> getProxyResults(MCMPRequest request) {
        if (!this.established) {
            return Collections.emptyMap();
        }
        Map<MCMPServerState, String> responses = this.mcmpHandler.sendRequest(request);
        if (responses.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<InetSocketAddress, String> results = new HashMap<InetSocketAddress, String>();
        for (Map.Entry<MCMPServerState, String> response : responses.entrySet()) {
            MCMPServerState state = response.getKey();
            results.put(state.getSocketAddress(), response.getValue());
        }
        return results;
    }

    @Override
    public void reset() {
        if (this.established) {
            this.mcmpHandler.reset();
        }
    }

    @Override
    public void refresh() {
        if (this.established) {
            this.mcmpHandler.markProxiesInError();
        }
    }

    @Override
    public boolean disable() {
        if (!this.established) {
            return false;
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(engine));
        }
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean enable() {
        if (!this.established) {
            return false;
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createEnableRequest(engine));
        }
        this.autoEnableContexts = true;
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean disableContext(String host, String path) {
        if (!this.established) {
            return false;
        }
        Context context = this.findContext(this.findHost(host), path);
        this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(context));
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean enableContext(String host, String path) {
        if (!this.established) {
            return false;
        }
        Context context = this.findContext(this.findHost(host), path);
        this.mcmpHandler.sendRequest(this.requestFactory.createEnableRequest(context));
        return this.mcmpHandler.isProxyHealthOK();
    }

    @Override
    public boolean stop(long timeout, TimeUnit unit) {
        if (!this.established) {
            return false;
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createDisableRequest(engine));
        }
        long start = System.currentTimeMillis();
        long end = start + unit.toMillis(timeout);
        for (Engine engine : this.server.getEngines()) {
            for (Host host : engine.getHosts()) {
                for (Context context : host.getContexts()) {
                    if (this.drainSessions(context, start, end)) continue;
                    return false;
                }
            }
        }
        for (Engine engine : this.server.getEngines()) {
            this.mcmpHandler.sendRequest(this.requestFactory.createStopRequest(engine));
        }
        return true;
    }

    @Override
    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        if (!this.established) {
            return false;
        }
        Context context = this.findContext(this.findHost(host), path);
        this.disable(context);
        long start = System.currentTimeMillis();
        boolean success = this.drainSessions(context, start, start + unit.toMillis(timeout));
        if (success) {
            this.mcmpHandler.sendRequest(this.requestFactory.createStopRequest(context));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M> boolean drainRequests(Context context, long start, long end) {
        EnablableRequestListener listener = (EnablableRequestListener)this.requestListeners.get(context);
        boolean noTimeout = start >= end;
        MCMPRequest request = this.requestFactory.createStopRequest(context);
        if (listener == null) {
            this.stop(request);
            return false;
        }
        EnablableRequestListener enablableRequestListener = listener;
        synchronized (enablableRequestListener) {
            boolean bl;
            listener.setEnabled(true);
            try {
                long current = System.currentTimeMillis();
                long timeout = end - current;
                int requests = this.stop(request);
                while (requests > 0 && (noTimeout || timeout > 0L)) {
                    this.log.debug((Object)Strings.DRAIN_REQUESTS_WAIT.getString(context, requests));
                    listener.wait(noTimeout ? 0L : timeout);
                    current = System.currentTimeMillis();
                    timeout = end - current;
                    requests = this.stop(request);
                }
                boolean success = requests == 0;
                float duration = (float)((success ? System.currentTimeMillis() : end) - start) / 1000.0f;
                if (success) {
                    this.log.info((Object)Strings.DRAIN_REQUESTS.getString(context, Float.valueOf(duration)));
                } else {
                    this.log.warn((Object)Strings.DRAIN_REQUESTS_TIMEOUT.getString(context, Float.valueOf(duration)));
                }
                bl = success;
            }
            catch (InterruptedException e) {
                boolean bl2;
                try {
                    Thread.currentThread().interrupt();
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    listener.setEnabled(false);
                    throw throwable;
                }
                listener.setEnabled(false);
                return bl2;
            }
            listener.setEnabled(false);
            return bl;
        }
    }

    private int stop(MCMPRequest request) {
        Map<MCMPServerState, String> responses = this.mcmpHandler.sendRequest(request);
        int requests = 0;
        for (String response : responses.values()) {
            requests += this.responseParser.parseStopAppResponse(response);
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drainSessions(Context context, long start, long end) {
        int remainingSessions = context.getActiveSessionCount();
        if (remainingSessions == 0) {
            return true;
        }
        boolean noTimeout = start >= end;
        NotifyOnDestroySessionListener listener = new NotifyOnDestroySessionListener();
        try {
            NotifyOnDestroySessionListener notifyOnDestroySessionListener = listener;
            synchronized (notifyOnDestroySessionListener) {
                context.addSessionListener(listener);
                long current = System.currentTimeMillis();
                long timeout = end - current;
                remainingSessions = context.getActiveSessionCount();
                while (remainingSessions > 0 && (noTimeout || timeout > 0L)) {
                    this.log.debug((Object)Strings.DRAIN_SESSIONS_WAIT.getString(context, remainingSessions));
                    listener.wait(noTimeout ? 0L : timeout);
                    current = System.currentTimeMillis();
                    timeout = end - current;
                    remainingSessions = context.getActiveSessionCount();
                }
            }
            boolean success = remainingSessions == 0;
            long seconds = TimeUnit.MILLISECONDS.toSeconds((success ? System.currentTimeMillis() : end) - start);
            if (success) {
                this.log.info((Object)Strings.DRAIN_SESSIONS.getString(context, seconds));
            } else {
                this.log.warn((Object)Strings.DRAIN_SESSIONS_TIMEOUT.getString(context, seconds));
            }
            boolean bl = success;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            context.removeSessionListener(listener);
        }
    }

    private Host findHost(String name) {
        for (Engine engine : this.server.getEngines()) {
            Host host = engine.findHost(name);
            if (host == null) continue;
            return host;
        }
        throw new IllegalArgumentException();
    }

    private Context findContext(Host host, String path) {
        Context context = host.findContext(path);
        if (context == null) {
            throw new IllegalArgumentException();
        }
        return context;
    }

    static class NotifyOnDestroySessionListener
    implements HttpSessionListener {
        NotifyOnDestroySessionListener() {
        }

        public void sessionCreated(HttpSessionEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDestroyed(HttpSessionEvent event) {
            NotifyOnDestroySessionListener notifyOnDestroySessionListener = this;
            synchronized (notifyOnDestroySessionListener) {
                this.notify();
            }
        }
    }

    static class NotifyOnDestroyRequestListener
    implements EnablableRequestListener {
        private volatile boolean enabled = false;

        NotifyOnDestroyRequestListener() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void requestInitialized(ServletRequestEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestDestroyed(ServletRequestEvent event) {
            if (this.enabled) {
                NotifyOnDestroyRequestListener notifyOnDestroyRequestListener = this;
                synchronized (notifyOnDestroyRequestListener) {
                    this.notify();
                }
            }
        }
    }

    static interface EnablableRequestListener
    extends Enablable,
    ServletRequestListener {
    }

    static interface Enablable {
        public boolean isEnabled();

        public void setEnabled(boolean var1);
    }
}

