/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.apache.xerces.util.SymbolTable;

public class SoftReferenceSymbolTable
extends SymbolTable {
    protected SREntry[] fBuckets = null;
    private final ReferenceQueue fReferenceQueue;

    public SoftReferenceSymbolTable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.fLoadFactor = loadFactor;
        this.fTableSize = initialCapacity;
        this.fBuckets = new SREntry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * loadFactor);
        this.fCount = 0;
        this.fReferenceQueue = new ReferenceQueue();
    }

    public SoftReferenceSymbolTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftReferenceSymbolTable() {
        this(101, 0.75f);
    }

    @Override
    public String addSymbol(String symbol) {
        this.clean();
        int bucket = this.hash(symbol) % this.fTableSize;
        SREntry entry = this.fBuckets[bucket];
        while (entry != null) {
            SREntryData data = (SREntryData)entry.get();
            if (data != null && data.symbol.equals(symbol)) {
                return data.symbol;
            }
            entry = entry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            bucket = this.hash(symbol) % this.fTableSize;
        }
        symbol = symbol.intern();
        this.fBuckets[bucket] = entry = new SREntry(symbol, this.fBuckets[bucket], bucket, this.fReferenceQueue);
        ++this.fCount;
        return symbol;
    }

    @Override
    public String addSymbol(char[] buffer, int offset, int length) {
        SREntry entry;
        this.clean();
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        SREntry entry2 = this.fBuckets[bucket];
        while (entry2 != null) {
            block5: {
                SREntryData data = (SREntryData)entry2.get();
                if (data != null && length == data.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == data.characters[i]) {
                            continue;
                        }
                        break block5;
                    }
                    return data.symbol;
                }
            }
            entry2 = entry2.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            bucket = this.hash(buffer, offset, length) % this.fTableSize;
        }
        String symbol = new String(buffer, offset, length).intern();
        this.fBuckets[bucket] = entry = new SREntry(symbol, buffer, offset, length, this.fBuckets[bucket], bucket, this.fReferenceQueue);
        ++this.fCount;
        return symbol;
    }

    @Override
    protected void rehash() {
        int oldCapacity = this.fBuckets.length;
        SREntry[] oldTable = this.fBuckets;
        int newCapacity = oldCapacity * 2 + 1;
        SREntry[] newTable = new SREntry[newCapacity];
        this.fThreshold = (int)((float)newCapacity * this.fLoadFactor);
        this.fBuckets = newTable;
        this.fTableSize = this.fBuckets.length;
        int i = oldCapacity;
        while (i-- > 0) {
            SREntry old = oldTable[i];
            while (old != null) {
                SREntry e = old;
                old = old.next;
                SREntryData data = (SREntryData)e.get();
                if (data != null) {
                    int index = this.hash(data.characters, 0, data.characters.length) % newCapacity;
                    if (newTable[index] != null) {
                        newTable[index].prev = e;
                    }
                    e.next = newTable[index];
                    newTable[index] = e;
                    continue;
                }
                --this.fCount;
            }
        }
    }

    @Override
    public boolean containsSymbol(String symbol) {
        int bucket = this.hash(symbol) % this.fTableSize;
        int length = symbol.length();
        SREntry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                SREntryData data = (SREntryData)entry.get();
                if (data != null && length == data.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (symbol.charAt(i) == data.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        SREntry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                SREntryData data = (SREntryData)entry.get();
                if (data != null && length == data.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == data.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    private void removeEntry(SREntry entry) {
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        } else {
            this.fBuckets[entry.bucket] = entry.next;
        }
        --this.fCount;
    }

    private void clean() {
        SREntry entry = (SREntry)this.fReferenceQueue.poll();
        while (entry != null) {
            this.removeEntry(entry);
            entry = (SREntry)this.fReferenceQueue.poll();
        }
    }

    protected static final class SREntryData {
        public final String symbol;
        public final char[] characters;

        public SREntryData(String internedSymbol) {
            this.symbol = internedSymbol;
            this.characters = new char[this.symbol.length()];
            this.symbol.getChars(0, this.characters.length, this.characters, 0);
        }

        public SREntryData(String internedSymbol, char[] ch, int offset, int length) {
            this.symbol = internedSymbol;
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
        }
    }

    protected static final class SREntry
    extends SoftReference {
        public SREntry next;
        public SREntry prev;
        public int bucket;

        public SREntry(String internedSymbol, SREntry next, int bucket, ReferenceQueue q) {
            super(new SREntryData(internedSymbol), q);
            this.initialize(next, bucket);
        }

        public SREntry(String internedSymbol, char[] ch, int offset, int length, SREntry next, int bucket, ReferenceQueue q) {
            super(new SREntryData(internedSymbol, ch, offset, length), q);
            this.initialize(next, bucket);
        }

        private void initialize(SREntry next, int bucket) {
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
            this.prev = null;
            this.bucket = bucket;
        }
    }
}

