/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ConfigAdminListener;
import org.jboss.as.osgi.service.ConfigAdminService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConfigAdminServiceImpl
implements ConfigAdminService {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final Set<ConfigAdminListener> listeners = new CopyOnWriteArraySet<ConfigAdminListener>();
    private final AtomicLong updateCount = new AtomicLong();
    private ServiceContainer serviceContainer;

    private ConfigAdminServiceImpl() {
    }

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        ConfigAdminServiceImpl service = new ConfigAdminServiceImpl();
        ServiceBuilder builder = target.addService(ConfigAdminService.SERVICE_NAME, (Service)service);
        builder.addDependency(SubsystemState.SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        builder.addListener(listeners);
        return builder.install();
    }

    private SubsystemState getSubsystemState() {
        return (SubsystemState)this.injectedSubsystemState.getValue();
    }

    @Override
    public Set<String> getConfigurations() {
        return this.getSubsystemState().getConfigurations();
    }

    @Override
    public boolean hasConfiguration(String pid) {
        return this.getSubsystemState().hasConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> getConfiguration(String pid) {
        return this.getSubsystemState().getConfiguration(pid);
    }

    @Override
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> newconfig) {
        Dictionary<String, String> oldconfig = this.getSubsystemState().putConfiguration(pid, newconfig);
        new ConfigurationModifiedService(pid, newconfig).configurationModified();
        return oldconfig;
    }

    @Override
    public Dictionary<String, String> removeConfiguration(String pid) {
        Dictionary<String, String> oldconfig = this.getSubsystemState().removeConfiguration(pid);
        new ConfigurationModifiedService(pid, oldconfig).configurationModified();
        return oldconfig;
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        log.debugf("Starting: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        log.debugf("Stopping: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
    }

    public ConfigAdminService getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public void addListener(ConfigAdminListener listener) {
        log.debugf("Add listener: %s", (Object)listener);
        this.listeners.add(listener);
        Set<String> pids = listener.getPIDs();
        if (pids != null) {
            for (String pid : pids) {
                Dictionary<String, String> props = this.getSubsystemState().getConfiguration(pid);
                listener.configurationModified(pid, props);
            }
        }
    }

    @Override
    public void removeListener(ConfigAdminListener listener) {
        log.debugf("Remove listener: %s", (Object)listener);
        this.listeners.remove(listener);
    }

    class ConfigurationModifiedService
    implements Service<Void> {
        private final String pid;
        private final Dictionary<String, String> props;

        private ConfigurationModifiedService(String pid, Dictionary<String, String> props) {
            this.pid = pid;
            this.props = props;
        }

        public void configurationModified() {
            String updatePart = new Long(ConfigAdminServiceImpl.this.updateCount.incrementAndGet()).toString();
            ServiceName serviceName = ServiceName.of((String[])new String[]{ConfigurationModifiedService.class.getName(), updatePart});
            ServiceBuilder builder = ConfigAdminServiceImpl.this.serviceContainer.addService(serviceName, (Service)this);
            builder.install();
        }

        public void start(StartContext context) throws StartException {
            ServiceController controller = context.getController();
            log.debugf("Starting: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
            HashSet snapshot = new HashSet(ConfigAdminServiceImpl.this.listeners);
            for (ConfigAdminListener aux : snapshot) {
                Set<String> pids = aux.getPIDs();
                if (pids != null && !pids.contains(this.pid)) continue;
                try {
                    aux.configurationModified(this.pid, this.props);
                }
                catch (Exception ex) {
                    log.errorf((Throwable)ex, "Error in configuration listener: %s", (Object)aux);
                }
            }
            context.getController().setMode(ServiceController.Mode.REMOVE);
        }

        public void stop(StopContext context) {
            ServiceController controller = context.getController();
            log.debugf("Stopping: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }
    }
}

