/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Dictionary;
import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiCasConfigRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    static final OSGiCasConfigRemove INSTANCE = new OSGiCasConfigRemove();

    private OSGiCasConfigRemove() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(OSGiSubsystemProviders.getResourceBundle(locale).getString("config.remove"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode identifier = operation.get("address").asObject().get("configuration");
        String pid = identifier.asString();
        SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
        Dictionary<String, String> oldValue = stateService.removeConfiguration(pid);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            stateService.putConfiguration(pid, oldValue);
        }
    }
}

