/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContextAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsLoginModule
implements LoginModule {
    private String roleName;
    private String principalName;
    private boolean pushedRole;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.roleName = (String)options.get("roleName");
        if (this.roleName == null) {
            this.roleName = "nobody";
        }
        this.principalName = (String)options.get("principalName");
        if (this.principalName == null) {
            this.principalName = "nobody";
        }
    }

    @Override
    public boolean login() {
        RunAsIdentity runAsRole = new RunAsIdentity(this.roleName, this.principalName);
        SecurityContextAssociation.pushRunAsIdentity(runAsRole);
        this.pushedRole = true;
        return true;
    }

    @Override
    public boolean commit() {
        return this.abort();
    }

    @Override
    public boolean abort() {
        if (!this.pushedRole) {
            return false;
        }
        SecurityContextAssociation.popRunAsIdentity();
        return true;
    }

    @Override
    public boolean logout() {
        return true;
    }
}

