/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.security.AccessController;
import java.security.PrivilegedAction;

class ServerConfig {
    static int clockTick;
    static int defaultClockTick;
    static long defaultReadTimeout;
    static long defaultWriteTimeout;
    static long defaultIdleInterval;
    static long defaultSelCacheTimeout;
    static int defaultMaxIdleConnections;
    static long defaultDrainAmount;
    static long readTimeout;
    static long writeTimeout;
    static long idleInterval;
    static long selCacheTimeout;
    static long drainAmount;
    static int maxIdleConnections;
    static boolean debug;

    ServerConfig() {
    }

    static long getReadTimeout() {
        return readTimeout;
    }

    static long getSelCacheTimeout() {
        return selCacheTimeout;
    }

    static boolean debugEnabled() {
        return debug;
    }

    static long getIdleInterval() {
        return idleInterval;
    }

    static int getClockTick() {
        return clockTick;
    }

    static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    static long getWriteTimeout() {
        return writeTimeout;
    }

    static long getDrainAmount() {
        return drainAmount;
    }

    static {
        defaultClockTick = 10000;
        defaultReadTimeout = 20L;
        defaultWriteTimeout = 60L;
        defaultIdleInterval = 300L;
        defaultSelCacheTimeout = 120L;
        defaultMaxIdleConnections = 200;
        defaultDrainAmount = 65536L;
        debug = false;
        idleInterval = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.idleInterval", defaultIdleInterval)) * 1000L;
        clockTick = AccessController.doPrivileged(new GetIntegerAction("sun.net.httpserver.clockTick", defaultClockTick));
        maxIdleConnections = AccessController.doPrivileged(new GetIntegerAction("sun.net.httpserver.maxIdleConnections", defaultMaxIdleConnections));
        readTimeout = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.readTimeout", defaultReadTimeout)) * 1000L;
        selCacheTimeout = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.selCacheTimeout", defaultSelCacheTimeout)) * 1000L;
        writeTimeout = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.writeTimeout", defaultWriteTimeout)) * 1000L;
        drainAmount = AccessController.doPrivileged(new GetLongAction("sun.net.httpserver.drainAmount", defaultDrainAmount));
        debug = AccessController.doPrivileged(new GetBooleanAction("sun.net.httpserver.debug"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetBooleanAction
    implements PrivilegedAction<Boolean> {
        private final String property;

        public GetBooleanAction(String property) {
            this.property = property;
        }

        @Override
        public Boolean run() {
            return Boolean.getBoolean(this.property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetIntegerAction
    implements PrivilegedAction<Integer> {
        private final String property;
        private final int defaultVal;

        public GetIntegerAction(String property, int defaultVal) {
            this.property = property;
            this.defaultVal = defaultVal;
        }

        @Override
        public Integer run() {
            return Integer.getInteger(this.property, this.defaultVal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetLongAction
    implements PrivilegedAction<Long> {
        private final String property;
        private final long defaultVal;

        public GetLongAction(String property, long defaultVal) {
            this.property = property;
            this.defaultVal = defaultVal;
        }

        @Override
        public Long run() {
            return Long.getLong(this.property, this.defaultVal);
        }
    }
}

