/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.annotation.javaee.DisplayNames;
import org.jboss.annotation.javaee.Icons;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.DisplayNameImpl;
import org.jboss.metadata.javaee.spec.DisplayNamesImpl;
import org.jboss.metadata.javaee.spec.IconImpl;
import org.jboss.metadata.javaee.spec.IconsImpl;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

public class ProcessorUtils {
    public static <E extends AnnotatedElement> Set<ResourceInjectionTargetMetaData> getInjectionTargets(String name, E element) {
        Set<ResourceInjectionTargetMetaData> injectionTargets = null;
        if (!(element instanceof Class)) {
            ResourceInjectionTargetMetaData target = new ResourceInjectionTargetMetaData();
            target.setInjectionTargetClass(ProcessorUtils.getDeclaringClass(element));
            target.setInjectionTargetName(name);
            injectionTargets = Collections.singleton(target);
        }
        return injectionTargets;
    }

    public static <E extends AnnotatedElement> String getName(E element) {
        String name = element.getClass().getSimpleName();
        if (element instanceof Class) {
            Class c = (Class)element;
            name = c.getSimpleName();
        } else if (element instanceof Field) {
            Field f = (Field)element;
            name = f.getName();
        } else if (element instanceof Method) {
            Method m = (Method)element;
            name = m.getName();
        }
        return name;
    }

    public static <E extends AnnotatedElement> String getDeclaringClass(E element) {
        String c = null;
        if (element instanceof Field) {
            Field f = (Field)element;
            c = f.getDeclaringClass().getName();
        } else if (element instanceof Method) {
            Method m = (Method)element;
            c = m.getDeclaringClass().getName();
        }
        return c;
    }

    public static Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add(di);
        }
        return descriptions;
    }

    public static DisplayNames getDisplayName(String displayName) {
        DisplayNamesImpl displayNames = null;
        if (displayName.length() > 0) {
            DisplayNameImpl dn = new DisplayNameImpl();
            dn.setDisplayName(displayName);
            displayNames = new DisplayNamesImpl();
            displayNames.add(dn);
        }
        return displayNames;
    }

    public static Icons getIcons(String smallIcon, String largeIcon) {
        IconsImpl icons = null;
        if (smallIcon.length() > 0 || largeIcon.length() > 0) {
            IconImpl i = new IconImpl();
            i.setSmallIcon(smallIcon);
            i.setLargeIcon(largeIcon);
            icons = new IconsImpl();
            icons.add(i);
        }
        return icons;
    }

    public static DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = ProcessorUtils.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    public static DescriptionGroupMetaData getDescriptionGroup(String description, String displayName, String smallIcon, String largeIcon) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0 || displayName.length() > 0 || smallIcon.length() > 0 || largeIcon.length() > 0) {
            Icons icons;
            DisplayNames displayNames;
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = ProcessorUtils.getDescription(description);
            if (descriptions != null) {
                dg.setDescriptions(descriptions);
            }
            if ((displayNames = ProcessorUtils.getDisplayName(displayName)) != null) {
                dg.setDisplayNames(displayNames);
            }
            if ((icons = ProcessorUtils.getIcons(smallIcon, largeIcon)) != null) {
                dg.setIcons(icons);
            }
        }
        return dg;
    }

    public static Collection<Class<? extends Annotation>> createAnnotationSet(Class<? extends Annotation> annotation) {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>(1);
        set.add(annotation);
        return set;
    }

    public static Collection<Class<? extends Annotation>> createAnnotationSet(Class<? extends Annotation> ... annotations) {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>();
        for (Class<? extends Annotation> annotation : annotations) {
            set.add(annotation);
        }
        return set;
    }
}

