/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata.services;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class DDEndpoint {
    private String id;
    private String address;
    private String implementor;
    private String invoker;
    private boolean mtomEnabled;
    private int mtomThreshold;
    private boolean addressingEnabled;
    private boolean addressingRequired;
    private String addressingResponses;
    private boolean respectBindingEnabled;
    private String wsdlLocation;
    private QName portName;
    private QName serviceName;
    private List<String> handlers;
    private Map<String, String> properties;
    private Class<?> epClass;
    private int counter = 0;

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getImplementor() {
        return this.implementor;
    }

    public void setImplementor(String implementor) {
        this.implementor = implementor;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public Class<?> getEpClass() {
        return this.epClass;
    }

    public void setEpClass(Class<?> epClass) {
        this.epClass = epClass;
    }

    public String getInvoker() {
        return this.invoker;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setInvoker(String invoker) {
        this.invoker = invoker;
    }

    public void setHandlers(List<String> handlers) {
        this.handlers = handlers;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<jaxws:endpoint id='" + this.id + "'");
        writer.write(" address='" + this.address + "'");
        writer.write(" implementor='" + this.implementor + "'");
        if (this.serviceName != null) {
            this.writeQNameElementTo("serviceName", this.serviceName, writer);
        }
        if (this.portName != null) {
            this.writeQNameElementTo("endpointName", this.portName, writer);
        }
        if (this.wsdlLocation != null) {
            writer.write(" wsdlLocation='" + this.wsdlLocation + "'");
        }
        writer.write(">");
        if (this.addressingEnabled) {
            String responses = "";
            if (this.addressingResponses != null) {
                responses = " responses='" + this.addressingResponses + "'";
            }
            writer.write("<jaxws:features>");
            writer.write("<wsa:addressing addressingRequired='" + this.addressingRequired + "'" + responses + "/>");
            writer.write("</jaxws:features>");
        }
        if (this.mtomEnabled) {
            writer.write("<jaxws:binding>");
            writer.write("<soap:soapBinding mtomEnabled='" + this.mtomEnabled + "'/>");
            writer.write("</jaxws:binding>");
        }
        if (this.mtomEnabled) {
            writer.write("<jaxws:dataBinding>");
            writer.write("<bean class='org.apache.cxf.jaxb.JAXBDataBinding'>");
            writer.write("<property name='mtomEnabled' value='true'/>");
            writer.write("<property name='mtomThreshold' value='" + this.mtomThreshold + "'/>");
            writer.write("</bean>");
            writer.write("</jaxws:dataBinding>");
        }
        if (this.invoker != null) {
            writer.write("<jaxws:invoker><bean class='" + this.invoker + "'/></jaxws:invoker>");
        }
        if (this.handlers != null && !this.handlers.isEmpty()) {
            writer.write("<jaxws:handlers>");
            for (String handler : this.handlers) {
                writer.write("<bean class='" + handler + "'/>");
            }
            writer.write("</jaxws:handlers>");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            writer.write("<jaxws:properties>");
            for (String key : this.properties.keySet()) {
                String value = this.properties.get(key);
                if (value == null) continue;
                writer.write("<entry key='" + key + "' value='" + value + "'/>");
            }
            writer.write("</jaxws:properties>");
        }
        writer.write("</jaxws:endpoint>");
    }

    private void writeQNameElementTo(String elementName, QName qname, Writer writer) throws IOException {
        String prefix = "ns" + this.counter++;
        writer.write(" " + elementName + "='" + prefix + ":" + qname.getLocalPart() + "'");
        writer.write(" xmlns:" + prefix + "='" + qname.getNamespaceURI() + "'");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Service");
        str.append("\n id=" + this.id);
        str.append("\n address=" + this.address);
        str.append("\n implementor=" + this.implementor);
        str.append("\n invoker=" + this.invoker);
        str.append("\n serviceName=" + this.serviceName);
        str.append("\n portName=" + this.portName);
        str.append("\n wsdlLocation=" + this.wsdlLocation);
        str.append("\n mtomEnabled=" + this.mtomEnabled);
        return str.toString();
    }
}

