/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class DomainControllerAddUtil {
    static Collection<ServiceController<?>> installLocalDomainController(ModelNode host, ServiceTarget serviceTarget, boolean isSlave, ServiceVerificationHandler verificationHandler) {
        ArrayList controllers = new ArrayList();
        String hostName = host.get("name").asString();
        String mgmtNetwork = host.get(new String[]{"management-interface", "native-interface", "interface"}).asString();
        int mgmtPort = host.get(new String[]{"management-interface", "native-interface", "port"}).asInt();
        return controllers;
    }

    static ServiceController<?> installRemoteDomainControllerConnection(ModelNode host, ServiceTarget serviceTarget, FileRepository localFileRepository) {
        try {
            String name = host.require("name").asString();
        }
        catch (NoSuchElementException e1) {
            throw new IllegalArgumentException("A host connecting to a remote domain controller must have its name attribute set");
        }
        ModelNode dc = host.require("domain-controller").require("remote");
        try {
            InetAddress addr = InetAddress.getByName(dc.require("host").resolve().asString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        int port = dc.require("port").resolve().asInt();
        return null;
    }
}

