/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlTokenBuilder
implements AssertionBuilder<Element> {
    private static final QName[] KNOWN_ELEMENTS = new QName[]{SP11Constants.SAML_TOKEN, SP12Constants.SAML_TOKEN};
    PolicyBuilder builder;

    public SamlTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SamlToken samlToken = new SamlToken(consts);
        samlToken.setOptional(PolicyConstants.isOptional((Element)element));
        samlToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            samlToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        Element child = DOMUtils.getFirstElement((Node)element);
        while (child != null) {
            NodeList policyChildren;
            String ln = child.getLocalName();
            if ("Policy".equals(ln) && (policyChildren = child.getChildNodes()) != null) {
                for (int i = 0; i < policyChildren.getLength(); ++i) {
                    Node policyChild = policyChildren.item(i);
                    if (!(policyChild instanceof Element)) continue;
                    QName qname = new QName(policyChild.getNamespaceURI(), policyChild.getLocalName());
                    if ("WssSamlV11Token10".equals(qname.getLocalPart())) {
                        samlToken.setUseSamlVersion11Profile10(true);
                        continue;
                    }
                    if ("WssSamlV11Token11".equals(qname.getLocalPart())) {
                        samlToken.setUseSamlVersion11Profile11(true);
                        continue;
                    }
                    if (!"WssSamlV20Token11".equals(qname.getLocalPart())) continue;
                    samlToken.setUseSamlVersion20Profile11(true);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
        return samlToken;
    }

    public QName[] getKnownElements() {
        return KNOWN_ELEMENTS;
    }
}

