/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;

public abstract class ProtocolChannel
implements Channel,
Channel.Receiver {
    protected final Logger log = Logger.getLogger((String)"org.jboss.as.protocol");
    private final String name;
    private final Channel channel;
    private boolean start;

    protected ProtocolChannel(String name, Channel channel) {
        this.name = name;
        this.channel = channel;
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
            }
        });
    }

    public synchronized void startReceiving() {
        if (this.start) {
            throw new IllegalStateException("Channel and receiver already started");
        }
        this.start = true;
        this.channel.receiveMessage((Channel.Receiver)this);
    }

    public String getName() {
        return this.name;
    }

    public Attachments getAttachments() {
        return this.channel.getAttachments();
    }

    public void awaitClosed() throws InterruptedException {
    }

    public MessageOutputStream writeMessage() throws IOException {
        return this.channel.writeMessage();
    }

    public void awaitClosedUninterruptibly() {
        this.channel.awaitClosedUninterruptibly();
    }

    public void closeAsync() {
        this.channel.closeAsync();
    }

    public HandleableCloseable.Key addCloseHandler(CloseHandler<? super Channel> handler) {
        return this.channel.addCloseHandler(handler);
    }

    public void writeShutdown() throws IOException {
        this.channel.writeShutdown();
    }

    public void receiveMessage(Channel.Receiver handler) {
        this.channel.receiveMessage(handler);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public void handleError(Channel channel, IOException error) {
        this.log.tracef((Throwable)error, "Handling error, closing channel %s", (Object)this);
        if (channel != this.channel) {
            this.log.warn((Object)"Received error for wrong channel!");
        }
        this.ended(channel);
    }

    public void handleEnd(Channel channel) {
        this.log.tracef("Handling end, closing channel %s", (Object)this);
        if (channel != this.channel) {
            this.log.warn((Object)"Received end for wrong channel!");
        }
        this.ended(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream message) {
        channel.receiveMessage((Channel.Receiver)this);
        this.doHandle(message);
    }

    protected abstract void doHandle(MessageInputStream var1);

    private void ended(Channel channel) {
        try {
            this.close();
        }
        catch (IOException e) {
            this.log.warnf("Got error closing channel %s", (Object)e.getMessage());
        }
    }
}

