/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSTopicService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final String name;
    private final String[] jndi;

    public JMSTopicService(String name, String[] jndi) {
        this.name = name;
        this.jndi = jndi;
    }

    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.createTopic(false, this.name, this.jndi);
        }
        catch (Exception e) {
            throw new StartException("failed to create topic", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.destroyTopic(this.name);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy jms topic: %s", (Object)this.name);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    public InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

