/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorRefsAttribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class MessagingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final MessagingSubsystemParser INSTANCE = new MessagingSubsystemParser();
    private static final EnumSet<Element> SIMPLE_ROOT_RESOURCE_ELEMENTS = EnumSet.noneOf(Element.class);

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private MessagingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging");
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "messaging");
        list.add(operation);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ACCEPTORS: {
                    ModelNode acceptors = MessagingSubsystemParser.processAcceptors(reader);
                    operation.get("acceptor").set(acceptors);
                    break;
                }
                case ADDRESS_SETTINGS: {
                    ModelNode addressSettings = MessagingSubsystemParser.processAddressSettings(reader);
                    operation.get("address-setting").set(addressSettings);
                    break;
                }
                case BINDINGS_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("bindings-directory").set(directory);
                    break;
                }
                case BRIDGES: {
                    MessagingSubsystemParser.processBridges(reader, address, list);
                    break;
                }
                case BROADCAST_GROUPS: {
                    MessagingSubsystemParser.processBroadcastGroups(reader, address, list);
                    break;
                }
                case CLUSTER_CONNECTIONS: {
                    MessagingSubsystemParser.processClusterConnections(reader, address, list);
                    break;
                }
                case CONNECTORS: {
                    ModelNode connectors = MessagingSubsystemParser.processConnectors(reader);
                    operation.get("connector").set(connectors);
                    break;
                }
                case CONNECTOR_SERVICES: {
                    MessagingSubsystemParser.processConnectorServices(reader, address, list);
                    break;
                }
                case DISCOVERY_GROUPS: {
                    MessagingSubsystemParser.processDiscoveryGroups(reader, address, list);
                    break;
                }
                case DIVERTS: {
                    MessagingSubsystemParser.parseDiverts(reader, address, list);
                    break;
                }
                case FILE_DEPLOYMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUPING_HANDLER: {
                    this.processGroupingHandler(reader, address, list);
                    break;
                }
                case JOURNAL_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("journal-directory").set(directory);
                    break;
                }
                case LARGE_MESSAGES_DIRECTORY: {
                    ModelNode dir = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("large-messages-directory").set(dir);
                    break;
                }
                case LIVE_CONNECTOR_REF: {
                    Location location = reader.getLocation();
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"connector-name");
                    CommonAttributes.LIVE_CONNECTOR_REF.parseAndSetParameter(string, operation, location);
                    break;
                }
                case PAGING_DIRECTORY: {
                    ModelNode directory = MessagingSubsystemParser.parseDirectory(reader);
                    operation.get("paging-directory").set(directory);
                    break;
                }
                case REMOTING_INTERCEPTORS: {
                    this.processRemotingInterceptors(reader, operation);
                    break;
                }
                case SECURITY_SETTINGS: {
                    ModelNode securitySettings = MessagingSubsystemParser.processSecuritySettings(reader);
                    operation.get("security-setting").set(securitySettings);
                    break;
                }
                case CORE_QUEUES: {
                    MessagingSubsystemParser.parseQueues(reader, address, list);
                    break;
                }
                case CONNECTION_FACTORIES: {
                    MessagingSubsystemParser.processConnectionFactories(reader, address, list);
                    break;
                }
                case JMS_DESTINATIONS: {
                    MessagingSubsystemParser.processJmsDestinations(reader, address, list);
                    break;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "server", operation);
                    break;
                }
                case SUBSYSTEM: {
                    break;
                }
                default: {
                    if (SIMPLE_ROOT_RESOURCE_ELEMENTS.contains((Object)element)) {
                        AttributeDefinition attributeDefinition = element.getDefinition();
                        if (attributeDefinition instanceof SimpleAttributeDefinition) {
                            MessagingSubsystemParser.handleElementText(reader, element, operation);
                            break;
                        }
                        throw new UnsupportedOperationException(String.format("Implement support for element %s", element.getLocalName()));
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        } while (reader.hasNext() && !localName.equals("subsystem"));
    }

    private static void processConnectorServices(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR_SERVICE: {
                    MessagingSubsystemParser.processConnectorService(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void processConnectorService(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode serviceAddress = address.clone().add("connector-service", name);
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress);
        updates.add(add);
        EnumSet<Element> required = EnumSet.of(Element.FACTORY_CLASS);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element) && element != Element.PARAM) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FACTORY_CLASS: {
                    MessagingSubsystemParser.handleElementText(reader, element, add);
                    continue block4;
                }
                case PARAM: {
                    Location location = reader.getLocation();
                    String[] attrs = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.KEY.getLocalName(), Attribute.VALUE.getLocalName()});
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    ModelNode paramAdd = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress.clone().add("param", attrs[0]));
                    CommonAttributes.VALUE.parseAndSetParameter(attrs[1], paramAdd, location);
                    updates.add(paramAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private static void processClusterConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_CONNECTION: {
                    MessagingSubsystemParser.processClusterConnection(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void processClusterConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("cluster-connection", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.CONNECTOR_REF);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FORWARD_WHEN_NO_CONSUMERS: 
                case MAX_HOPS: 
                case CONFIRMATION_WINDOW_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block8;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.CLUSTER_CONNECTION_ADDRESS.getName(), bridgeAdd);
                    continue block8;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "simple", bridgeAdd);
                    continue block8;
                }
                case USE_DUPLICATE_DETECTION: 
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "cluster", bridgeAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    if (seen.contains((Object)Element.DISCOVERY_GROUP_REF)) {
                        throw new XMLStreamException(String.format("Illegal element %s: cannot be used when %s is used", "static-connectors", "discovery-group-ref"), reader.getLocation());
                    }
                    MessagingSubsystemParser.processStaticConnectors(reader, bridgeAdd, true);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    if (seen.contains((Object)Element.STATIC_CONNECTORS)) {
                        throw new XMLStreamException(String.format("Illegal element %s: cannot be used when %s is used", "discovery-group-ref", "static-connectors"), reader.getLocation());
                    }
                    Location location = reader.getLocation();
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, location);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    private static void processBridges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BRIDGE: {
                    MessagingSubsystemParser.processBridge(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void processBridge(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("bridge", name));
        EnumSet<Element> required = EnumSet.of(Element.QUEUE_NAME);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case CONFIRMATION_WINDOW_SIZE: 
                case USE_DUPLICATE_DETECTION: 
                case QUEUE_NAME: 
                case HA: 
                case TRANSFORMER_CLASS_NAME: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case USER: 
                case PASSWORD: {
                    MessagingSubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block8;
                }
                case FILTER: {
                    Location location = reader.getLocation();
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, bridgeAdd, location);
                    continue block8;
                }
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "default", bridgeAdd);
                    continue block8;
                }
                case FORWARDING_ADDRESS: 
                case RECONNECT_ATTEMPTS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    if (seen.contains((Object)Element.DISCOVERY_GROUP_REF)) {
                        throw new XMLStreamException(String.format("Illegal element %s: cannot be used when %s is used", "static-connectors", "discovery-group-ref"), reader.getLocation());
                    }
                    MessagingSubsystemParser.processStaticConnectors(reader, bridgeAdd, false);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    if (seen.contains((Object)Element.STATIC_CONNECTORS)) {
                        throw new XMLStreamException(String.format("Illegal element %s: cannot be used when %s is used", "discovery-group-ref", "static-connectors"), reader.getLocation());
                    }
                    Location location = reader.getLocation();
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, location);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!seen.contains((Object)Element.STATIC_CONNECTORS) && !seen.contains((Object)Element.DISCOVERY_GROUP_REF)) {
            throw new XMLStreamException(String.format("Either %s or %s is required", Element.STATIC_CONNECTORS.getLocalName(), Element.DISCOVERY_GROUP_REF.getLocalName()), reader.getLocation());
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    private static void processStaticConnectors(XMLExtendedStreamReader reader, ModelNode addOperation, boolean cluster) throws XMLStreamException {
        if (cluster) {
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ALLOW_DIRECT_CONNECTIONS_ONLY: {
                        Location location = reader.getLocation();
                        String attrValue = reader.getAttributeValue(i);
                        CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.parseAndSetParameter(attrValue, addOperation, location);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        } else {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        EnumSet<Element> required = EnumSet.of(Element.CONNECTOR_REF);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, cluster ? "cluster-connection" : "bridge", addOperation);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void processGroupingHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode groupingHandlerAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("grouping-handler", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.TYPE);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case TYPE: 
                case TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, groupingHandlerAdd);
                    continue block4;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.GROUPING_HANDLER_ADDRESS.getName(), groupingHandlerAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(groupingHandlerAdd);
    }

    private void processRemotingInterceptors(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS_NAME: {
                    Location location = reader.getLocation();
                    String value = reader.getElementText();
                    CommonAttributes.REMOTING_INTERCEPTORS.parseAndAddParameterElement(value, operation, location);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processBroadcastGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BROADCAST_GROUP: {
                    MessagingSubsystemParser.parseBroadcastGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseBroadcastGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode broadcastGroupAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("broadcast-group", name));
        EnumSet<Element> required = EnumSet.of(Element.GROUP_ADDRESS, Element.GROUP_PORT);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case LOCAL_BIND_PORT: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case BROADCAST_PERIOD: {
                    MessagingSubsystemParser.handleElementText(reader, element, broadcastGroupAdd);
                    continue block4;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "broadcast-group", broadcastGroupAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(broadcastGroupAdd);
    }

    static void processDiscoveryGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP: {
                    MessagingSubsystemParser.parseDiscoveryGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDiscoveryGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode broadcastGroupAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("discovery-group", name));
        EnumSet<Element> required = EnumSet.of(Element.GROUP_ADDRESS, Element.GROUP_PORT);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case REFRESH_TIMEOUT: 
                case INITIAL_WAIT_TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, broadcastGroupAdd);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(broadcastGroupAdd);
    }

    static void processConnectionFactories(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    MessagingSubsystemParser.processConnectionFactory(reader, address, updates);
                    continue block4;
                }
                case POOLED_CONNECTION_FACTORY: {
                    MessagingSubsystemParser.processPooledConnectionFactory(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processJmsDestinations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMS_QUEUE: {
                    MessagingSubsystemParser.processJMSQueue(reader, address, updates);
                    continue block4;
                }
                case JMS_TOPIC: {
                    MessagingSubsystemParser.processJMSTopic(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode processAcceptors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode acceptors = new ModelNode();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.Generic.toString());
                    if (socketBinding != null) {
                        acceptor.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, true);
                    continue block10;
                }
                case NETTY_ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.Remote.toString());
                    if (socketBinding != null) {
                        acceptor.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    continue block10;
                }
                case IN_VM_ACCEPTOR: {
                    ModelNode acceptor = acceptors.get(name);
                    acceptor.get("type").set(MessagingServices.TransportConfigType.InVM.toString());
                    acceptor.get("server-id").set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, acceptor, false);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return acceptors;
    }

    static void parseQueues(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block7: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case QUEUE: {
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
                    }
                    ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("queue", name));
                    MessagingSubsystemParser.parseQueue(reader, op);
                    if (!op.hasDefined(CommonAttributes.QUEUE_ADDRESS.getName())) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.ADDRESS.getLocalName()));
                    }
                    list.add(op);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseQueue(XMLExtendedStreamReader reader, ModelNode queue) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.QUEUE_ADDRESS.getName(), queue);
                    continue block5;
                }
                case FILTER: {
                    Location location = reader.getLocation();
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, queue, location);
                    continue block5;
                }
                case DURABLE: {
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode processSecuritySettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode security = new ModelNode();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_SETTING: {
                    String match = reader.getAttributeValue(0);
                    MessagingSubsystemParser.parseSecurityRoles(reader, security.get(match));
                }
            }
        } while (reader.hasNext() && localName.equals(Element.SECURITY_SETTING.getLocalName()));
        return security;
    }

    static void parseSecurityRoles(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element != Element.PERMISSION_ELEMENT_NAME) break;
            List roles = null;
            String type = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ROLES_ATTR_NAME: {
                        roles = reader.getListAttributeValue(i);
                        continue block5;
                    }
                    case TYPE_ATTR_NAME: {
                        type = reader.getAttributeValue(i);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            for (String role : roles) {
                if (Attribute.SEND_NAME.getLocalName().equals(type)) {
                    send.add(role.trim());
                } else if (Attribute.CONSUME_NAME.getLocalName().equals(type)) {
                    consume.add(role.trim());
                } else if (Attribute.CREATEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    createDurableQueue.add(role);
                } else if (Attribute.DELETEDURABLEQUEUE_NAME.getLocalName().equals(type)) {
                    deleteDurableQueue.add(role);
                } else if (Attribute.CREATE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETE_NON_DURABLE_QUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.CREATETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    createNonDurableQueue.add(role);
                } else if (Attribute.DELETETEMPQUEUE_NAME.getLocalName().equals(type)) {
                    deleteNonDurableQueue.add(role);
                } else if (Attribute.MANAGE_NAME.getLocalName().equals(type)) {
                    manageRoles.add(role);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
            reader.discardRemainder();
        } while (reader.hasNext());
        for (String role : allRoles) {
            node.get(new String[]{role, "send"}).set(send.contains(role));
            node.get(new String[]{role, "consume"}).set(consume.contains(role));
            node.get(new String[]{role, "createDurableQueue"}).set(createDurableQueue.contains(role));
            node.get(new String[]{role, "deleteDurableQueue"}).set(deleteDurableQueue.contains(role));
            node.get(new String[]{role, "createNonDurableQueue"}).set(createNonDurableQueue.contains(role));
            node.get(new String[]{role, "deleteNonDurableQueue"}).set(deleteNonDurableQueue.contains(role));
            node.get(new String[]{role, "manage"}).set(manageRoles.contains(role));
        }
    }

    public static ModelNode processConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.Generic.toString());
                    if (socketBinding != null) {
                        connector.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, true);
                    continue block10;
                }
                case NETTY_CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.Remote.toString());
                    if (socketBinding != null) {
                        connector.get("socket-binding").set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    continue block10;
                }
                case IN_VM_CONNECTOR: {
                    ModelNode connector = connectors.get(name);
                    connector.get("type").set(MessagingServices.TransportConfigType.InVM.toString());
                    connector.get("server-id").set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, connector, false);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return connectors;
    }

    static ModelNode processAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode settings = new ModelNode();
        String localName = null;
        int tag = reader.getEventType();
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case ADDRESS_SETTING: {
                    String match = reader.getAttributeValue(0);
                    settings.get(match).set(MessagingSubsystemParser.parseAddressSettings(reader));
                }
            }
        } while (reader.hasNext() && localName.equals(Element.ADDRESS_SETTING.getLocalName()));
        return settings;
    }

    static ModelNode parseAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addressSettingsSpec = new ModelNode();
        String localName = null;
        do {
            int tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case DEAD_LETTER_ADDRESS_NODE_NAME: 
                case EXPIRY_ADDRESS_NODE_NAME: 
                case REDELIVERY_DELAY_NODE_NAME: 
                case MAX_SIZE_BYTES_NODE_NAME: 
                case PAGE_SIZE_BYTES_NODE_NAME: 
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME: 
                case ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME: 
                case LVQ_NODE_NAME: 
                case MAX_DELIVERY_ATTEMPTS: 
                case REDISTRIBUTION_DELAY_NODE_NAME: 
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.handleElementText(reader, element, addressSettingsSpec);
                    break;
                }
            }
        } while (!reader.getLocalName().equals(Element.ADDRESS_SETTING.getLocalName()) && reader.getEventType() == 2);
        return addressSettingsSpec;
    }

    static void parseTransportConfigurationParams(XMLExtendedStreamReader reader, ModelNode transportConfig, boolean generic) throws XMLStreamException {
        ModelNode params = new ModelNode();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            int count = reader.getAttributeCount();
            String key = null;
            String value = null;
            block9: for (int n = 0; n < count; ++n) {
                String attrName = reader.getAttributeLocalName(n);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case KEY: {
                        key = reader.getAttributeValue(n);
                        continue block9;
                    }
                    case VALUE: {
                        value = reader.getAttributeValue(n);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FACTORY_CLASS: {
                    if (!generic) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    transportConfig.get(CommonAttributes.FACTORY_CLASS.getName()).set(reader.getElementText().trim());
                    continue block8;
                }
                case PARAM: {
                    params.add(key, value);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        transportConfig.get("param").set(params);
    }

    static ModelNode parseDirectory(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode directory = new ModelNode();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case RELATIVE_TO: {
                    directory.get("relative-to").set(value);
                    continue block4;
                }
                case PATH: {
                    directory.get("path").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return directory;
    }

    private static void parseDiverts(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DIVERT: {
                    MessagingSubsystemParser.parseDivert(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDivert(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode divertAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("divert", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.FORWARDING_ADDRESS);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case ROUTING_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.DIVERT_ADDRESS.getName(), divertAdd);
                    continue block8;
                }
                case FORWARDING_ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "divert", divertAdd);
                    continue block8;
                }
                case FILTER: {
                    Location location = reader.getLocation();
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, divertAdd, location);
                    continue block8;
                }
                case TRANSFORMER_CLASS_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case EXCLUSIVE: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        list.add(divertAdd);
    }

    static void unhandledElement(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        throw new XMLStreamException(String.format("Ignoring unhandled element: %s, at: %s", new Object[]{element, reader.getLocation().toString()}));
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node) throws XMLStreamException {
        MessagingSubsystemParser.handleElementText(reader, element, null, node);
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, String modelName, ModelNode node) throws XMLStreamException {
        AttributeDefinition attributeDefinition;
        AttributeDefinition attributeDefinition2 = attributeDefinition = modelName == null ? element.getDefinition() : element.getDefinition(modelName);
        if (attributeDefinition != null) {
            Location location = reader.getLocation();
            String value = reader.getElementText();
            if (attributeDefinition instanceof SimpleAttributeDefinition) {
                ((SimpleAttributeDefinition)attributeDefinition).parseAndSetParameter(value, node, location);
            } else if (attributeDefinition instanceof ListAttributeDefinition) {
                ((ListAttributeDefinition)attributeDefinition).parseAndAddParameterElement(value, node, location);
            }
        } else {
            MessagingSubsystemParser.handleElementText(reader, element, node, ModelType.STRING, true, false);
        }
    }

    @Deprecated
    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node, ModelType expectedType, boolean allowNull, boolean allowExpression) throws XMLStreamException {
        Location location = reader.getLocation();
        String value = reader.getElementText();
        if (value != null && value.length() > 0) {
            ModelNode modelValue;
            ModelNode toSet = node.get(element.getLocalName());
            ModelNode modelNode = modelValue = allowExpression ? ParseUtils.parsePossibleExpression((String)value.trim()) : new ModelNode().set(value.trim());
            if (!allowExpression || modelValue.getType() != ModelType.EXPRESSION) {
                toSet.set(modelValue);
            } else {
                try {
                    switch (expectedType) {
                        case BOOLEAN: {
                            toSet.set(modelValue.asBoolean());
                            break;
                        }
                        case BIG_DECIMAL: {
                            toSet.set(modelValue.asBigDecimal());
                            break;
                        }
                        case BIG_INTEGER: {
                            toSet.set(modelValue.asBigInteger());
                            break;
                        }
                        case BYTES: {
                            toSet.set(modelValue.asBytes());
                            break;
                        }
                        case DOUBLE: {
                            toSet.set(modelValue.asDouble());
                            break;
                        }
                        case INT: {
                            toSet.set(modelValue.asInt());
                            break;
                        }
                        case LONG: {
                            toSet.set(modelValue.asLong());
                            break;
                        }
                        case STRING: {
                            toSet.set(modelValue.asString());
                            break;
                        }
                        default: {
                            throw new XMLStreamException(String.format("Illegal value %s for element %s", value, element.getLocalName()), location);
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new XMLStreamException(String.format("Illegal value %s for element %s as it could not be converted to required type %s", value, element.getLocalName(), expectedType), location);
                }
            }
        } else if (!allowNull) {
            throw new XMLStreamException(String.format("Illegal value %s for element %s", value, element.getLocalName()), location);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        for (AttributeDefinition simpleAttribute : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            simpleAttribute.marshallAsElement(node, (XMLStreamWriter)writer);
        }
        if (this.has(node, "acceptor")) {
            this.writeAcceptors(writer, node.get("acceptor"));
        }
        if (this.has(node, "address-setting")) {
            this.writeAddressSettings(writer, node.get("address-setting"));
        }
        if (this.has(node, "bindings-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.BINDINGS_DIRECTORY, node);
        }
        if (this.has(node, "connector")) {
            this.writeConnectors(writer, node.get("connector"));
        }
        if (node.hasDefined("broadcast-group")) {
            this.writeBroadcastGroups(writer, node.get("broadcast-group"));
        }
        if (node.hasDefined("discovery-group")) {
            this.writeDiscoveryGroups(writer, node.get("discovery-group"));
        }
        if (node.hasDefined("divert")) {
            this.writeDiverts(writer, node.get("divert"));
        }
        if (node.hasDefined("bridge")) {
            this.writeBridges(writer, node.get("bridge"));
        }
        if (node.hasDefined("cluster-connection")) {
            this.writeClusterConnections(writer, node.get("cluster-connection"));
        }
        if (node.hasDefined("grouping-handler")) {
            this.writeGroupingHandler(writer, node.get("grouping-handler"));
        }
        if (this.has(node, "journal-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.JOURNAL_DIRECTORY, node);
        }
        if (this.has(node, "large-messages-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.LARGE_MESSAGES_DIRECTORY, node);
        }
        if (this.has(node, "paging-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.PAGING_DIRECTORY, node);
        }
        if (this.has(node, "security-setting")) {
            this.writeSecuritySettings(writer, node.get("security-setting"));
        }
        if (this.has(node, "queue")) {
            this.writeQueues(writer, node.get("queue"));
        }
        if (node.hasDefined("connector-service")) {
            this.writeConnectorServices(writer, node.get("connector-service"));
        }
        if (node.has("connection-factory") || node.has("pooled-connection-factory")) {
            writer.writeStartElement("jms-connection-factories");
            if (node.has("connection-factory")) {
                this.writeConnectionFactories(writer, node.get("connection-factory"));
            }
            if (node.has("pooled-connection-factory")) {
                this.writePooledConnectionFactories(writer, node.get("pooled-connection-factory"));
            }
            writer.writeEndElement();
        }
        if (node.has("jms-queue") || node.has("jms-topic")) {
            writer.writeStartElement("jms-destinations");
            if (node.has("jms-queue")) {
                this.writeJmsQueues(writer, node.get("jms-queue"));
            }
            if (node.has("jms-topic")) {
                this.writeTopics(writer, node.get("jms-topic"));
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeConnectorServices(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CONNECTOR_SERVICES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CONNECTOR_SERVICE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode service = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                if (service.hasDefined("param")) {
                    for (Property param : service.get("param").asPropertyList()) {
                        writer.writeEmptyElement(Element.PARAM.getLocalName());
                        writer.writeAttribute(Attribute.KEY.getLocalName(), param.getName());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), param.getValue().get(CommonAttributes.VALUE.getName()).asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeBridges(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BRIDGES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.BRIDGE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode bridge = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.BRIDGE_ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        this.writeFilter(writer, property.getValue());
                        continue;
                    }
                    if (attribute == CommonAttributes.DISCOVERY_GROUP_NAME) {
                        if (!CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(bridge, false)) continue;
                        writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
                        CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(bridge, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeClusterConnections(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CLUSTER_CONNECTIONS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CLUSTER_CONNECTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode cluster = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
                    if (attribute == CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY) continue;
                    if (attribute == ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS) {
                        if (ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.isMarshallable(cluster, false)) {
                            writer.writeStartElement(Element.STATIC_CONNECTORS.getLocalName());
                            CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                            ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.marshallAsElement(cluster, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                            continue;
                        }
                        if (!CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.isMarshallable(cluster, false)) continue;
                        writer.writeEmptyElement(Element.STATIC_CONNECTORS.getLocalName());
                        CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                        continue;
                    }
                    if (attribute == CommonAttributes.DISCOVERY_GROUP_NAME) {
                        if (!CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(cluster, false)) continue;
                        writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
                        CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeGroupingHandler(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean wroteHandler = false;
        for (Property handler : node.asPropertyList()) {
            if (wroteHandler) {
                throw new IllegalStateException(String.format("Multiple %s children found; only one is allowed", "grouping-handler"));
            }
            writer.writeStartElement(Element.GROUPING_HANDLER.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), handler.getName());
            ModelNode resourceModel = handler.getValue();
            for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
                attr.marshallAsElement(resourceModel, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeAcceptors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ACCEPTORS.getLocalName());
        for (Property property : node.asPropertyList()) {
            ModelNode value = property.getValue();
            if (!this.has(value, "type")) continue;
            switch (Enum.valueOf(MessagingServices.TransportConfigType.class, value.get("type").asString())) {
                case Generic: {
                    writer.writeStartElement(Element.ACCEPTOR.getLocalName());
                    break;
                }
                case Remote: {
                    writer.writeStartElement(Element.NETTY_ACCEPTOR.getLocalName());
                    break;
                }
                case InVM: {
                    writer.writeStartElement(Element.IN_VM_ACCEPTOR.getLocalName());
                }
            }
            this.writeAcceptorAndConnectorContent(writer, property);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeConnectors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.CONNECTORS.getLocalName());
        for (Property property : node.asPropertyList()) {
            ModelNode value = property.getValue();
            if (!this.has(value, "type")) continue;
            switch (Enum.valueOf(MessagingServices.TransportConfigType.class, value.get("type").asString())) {
                case Generic: {
                    writer.writeStartElement(Element.CONNECTOR.getLocalName());
                    break;
                }
                case Remote: {
                    writer.writeStartElement(Element.NETTY_CONNECTOR.getLocalName());
                    break;
                }
                case InVM: {
                    writer.writeStartElement(Element.IN_VM_CONNECTOR.getLocalName());
                }
            }
            this.writeAcceptorAndConnectorContent(writer, property);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeAcceptorAndConnectorContent(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        ModelNode value = property.getValue();
        if (this.has(value, "socket-binding")) {
            this.writeAttribute(writer, Attribute.SOCKET_BINDING, value.get("socket-binding"));
        }
        if (this.has(value, "server-id")) {
            this.writeAttribute(writer, Attribute.SERVER_ID, value.get("server-id"));
        }
        if (this.has(value, CommonAttributes.FACTORY_CLASS.getName())) {
            MessagingSubsystemParser.writeSimpleElement(writer, Element.FACTORY_CLASS, value);
        }
        if (this.has(value, "param")) {
            for (Property parameter : value.get("param").asPropertyList()) {
                writer.writeStartElement(Element.PARAM.getLocalName());
                writer.writeAttribute(Attribute.KEY.getLocalName(), parameter.getName());
                this.writeAttribute(writer, Attribute.VALUE, parameter.getValue());
                writer.writeEndElement();
            }
        }
    }

    private void writeSecuritySettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.SECURITY_SETTINGS.getLocalName());
        for (Property matchRoles : node.asPropertyList()) {
            writer.writeStartElement(Element.SECURITY_SETTING.getLocalName());
            writer.writeAttribute(Attribute.MATCH.getLocalName(), matchRoles.getName());
            ArrayList<String> send = new ArrayList<String>();
            ArrayList<String> consume = new ArrayList<String>();
            ArrayList<String> createDurableQueue = new ArrayList<String>();
            ArrayList<String> deleteDurableQueue = new ArrayList<String>();
            ArrayList<String> createNonDurableQueue = new ArrayList<String>();
            ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
            ArrayList<String> manageRoles = new ArrayList<String>();
            for (Property rolePerms : matchRoles.getValue().asPropertyList()) {
                String role = rolePerms.getName();
                ModelNode perms = rolePerms.getValue();
                if (perms.get("send").asBoolean()) {
                    send.add(role);
                }
                if (perms.get("consume").asBoolean()) {
                    consume.add(role);
                }
                if (perms.get("createDurableQueue").asBoolean()) {
                    createDurableQueue.add(role);
                }
                if (perms.get("deleteDurableQueue").asBoolean()) {
                    deleteDurableQueue.add(role);
                }
                if (perms.get("createNonDurableQueue").asBoolean()) {
                    createNonDurableQueue.add(role);
                }
                if (perms.get("deleteNonDurableQueue").asBoolean()) {
                    deleteNonDurableQueue.add(role);
                }
                if (!perms.get("manage").asBoolean()) continue;
                manageRoles.add(role);
            }
            this.writePermission(writer, "send", send);
            this.writePermission(writer, "consume", consume);
            this.writePermission(writer, "createDurableQueue", createDurableQueue);
            this.writePermission(writer, "deleteDurableQueue", deleteDurableQueue);
            this.writePermission(writer, "createNonDurableQueue", createNonDurableQueue);
            this.writePermission(writer, "deleteNonDurableQueue", deleteNonDurableQueue);
            this.writePermission(writer, "manage", manageRoles);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePermission(XMLExtendedStreamWriter writer, String type, List<String> roles) throws XMLStreamException {
        if (roles.size() == 0) {
            return;
        }
        writer.writeStartElement(Element.PERMISSION_ELEMENT_NAME.getLocalName());
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(role);
        }
        writer.writeAttribute(Attribute.TYPE_ATTR_NAME.getLocalName(), type);
        writer.writeAttribute(Attribute.ROLES_ATTR_NAME.getLocalName(), sb.toString());
        writer.writeEndElement();
    }

    private void writeAddressSettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ADDRESS_SETTINGS.getLocalName());
        for (Property matchSetting : node.asPropertyList()) {
            writer.writeStartElement(Element.ADDRESS_SETTING.getLocalName());
            writer.writeAttribute(Attribute.MATCH.getLocalName(), matchSetting.getName());
            ModelNode setting = matchSetting.getValue();
            if (this.has(setting, "dead-letter-address")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.DEAD_LETTER_ADDRESS_NODE_NAME, setting);
            }
            if (this.has(setting, "expiry-address")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.EXPIRY_ADDRESS_NODE_NAME, setting);
            }
            if (this.has(setting, "redelivery-delay")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.REDELIVERY_DELAY_NODE_NAME, setting);
            }
            if (this.has(setting, "max-size-bytes")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MAX_SIZE_BYTES_NODE_NAME, setting);
            }
            if (this.has(setting, "page-size-bytes")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.PAGE_SIZE_BYTES_NODE_NAME, setting);
            }
            if (this.has(setting, "message-counter-history-day-limit")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME, setting);
            }
            if (this.has(setting, "address-full-policy")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, setting);
            }
            if (this.has(setting, "last-value-queue")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.LVQ_NODE_NAME, setting);
            }
            if (this.has(setting, "max-delivery-attempts")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.MAX_DELIVERY_ATTEMPTS, setting);
            }
            if (this.has(setting, "redistribution-delay")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.REDISTRIBUTION_DELAY_NODE_NAME, setting);
            }
            if (this.has(setting, "send-to-dla-on-no-route")) {
                MessagingSubsystemParser.writeSimpleElement(writer, Element.SEND_TO_DLA_ON_NO_ROUTE, setting);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.CORE_QUEUES.getLocalName());
        for (Property queueProp : node.asPropertyList()) {
            writer.writeStartElement(Element.QUEUE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), queueProp.getName());
            ModelNode queue = queueProp.getValue();
            CommonAttributes.QUEUE_ADDRESS.marshallAsElement(queue, (XMLStreamWriter)writer);
            this.writeFilter(writer, queue);
            CommonAttributes.DURABLE.marshallAsElement(queue, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeBroadcastGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BROADCAST_GROUPS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.BROADCAST_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeDiscoveryGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DISCOVERY_GROUPS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.DISCOVERY_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeDiverts(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DIVERTS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.DIVERT.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.DIVERT_ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        this.writeFilter(writer, property.getValue());
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeFilter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(CommonAttributes.FILTER.getName())) {
            writer.writeEmptyElement(CommonAttributes.FILTER.getXmlName());
            writer.writeAttribute("string", node.get(CommonAttributes.FILTER.getName()).asString());
        }
    }

    static void writeSimpleElement(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String content;
        String localName = element.getLocalName();
        if (node.has(localName) && (content = node.get(localName).asString()) != null) {
            writer.writeStartElement(localName);
            writer.writeCharacters(content);
            writer.writeEndElement();
        }
    }

    static void writeDirectory(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String localName = element.getLocalName();
        if (node.has(localName)) {
            String relativeTo;
            String path = node.get(localName).has("path") ? node.get(new String[]{localName, "path"}).asString() : null;
            String string = relativeTo = node.get(localName).has("relative-to") ? node.get(new String[]{localName, "relative-to"}).asString() : null;
            if (path != null || relativeTo != null) {
                writer.writeEmptyElement(localName);
                if (path != null) {
                    writer.writeAttribute("path", path);
                }
                if (relativeTo != null) {
                    writer.writeAttribute("relative-to", relativeTo);
                }
            }
        }
    }

    private void writeConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            String name = prop.getName();
            ModelNode factory = prop.getValue();
            if (!factory.isDefined()) continue;
            writer.writeStartElement(Element.CONNECTION_FACTORY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            this.writeConnectionFactory(writer, node, name, factory);
        }
    }

    private void writePooledConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            String name = prop.getName();
            ModelNode factory = prop.getValue();
            if (!factory.isDefined()) continue;
            writer.writeStartElement(Element.POOLED_CONNECTION_FACTORY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            this.writeConnectionFactory(writer, node, name, factory);
        }
    }

    private void writeConnectionFactory(XMLExtendedStreamWriter writer, ModelNode node, String name, ModelNode factory) throws XMLStreamException {
        ModelNode inboundConfigs;
        if (CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(node, false)) {
            writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
            CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (this.has(factory, "connector")) {
            writer.writeStartElement(Element.CONNECTORS.getLocalName());
            for (Property connProp : factory.get("connector").asPropertyList()) {
                ModelNode conn = connProp.getValue();
                if (!conn.isDefined()) continue;
                writer.writeStartElement(Element.CONNECTOR_REF.getLocalName());
                writer.writeAttribute(Attribute.CONNECTOR_NAME.getLocalName(), connProp.getName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        JndiEntriesAttribute.CONNECTION_FACTORY.marshallAsElement(factory, (XMLStreamWriter)writer);
        if (this.has(factory, "transaction")) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            this.writeTransactionTypeAttribute(writer, Element.MODE, factory.get("transaction"));
            writer.writeEndElement();
        }
        if (this.has(factory, "inbound-config") && (inboundConfigs = factory.get("inbound-config")).getType() == ModelType.LIST) {
            writer.writeStartElement(Element.INBOUND_CONFIG.getLocalName());
            for (ModelNode config : inboundConfigs.asList()) {
                if (!config.isDefined()) continue;
                CommonAttributes.USE_JNDI.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.JNDI_PARAMS.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.SETUP_ATTEMPTS.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.SETUP_INTERVAL.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.USE_LOCAL_TX.marshallAsElement(config, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        CommonAttributes.DISCOVERY_INITIAL_WAIT_TIMEOUT.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_TTL.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CALL_TIMEOUT.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONSUMER_WINDOW_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONSUMER_MAX_RATE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONFIRMATION_WINDOW_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.PRODUCER_WINDOW_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.PRODUCER_MAX_RATE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.MIN_LARGE_MESSAGE_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CLIENT_ID.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.DUPS_OK_BATCH_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.TRANSACTION_BATCH_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_ACK.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_DURABLE_SEND.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.AUTO_GROUP.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.PRE_ACK.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.RETRY_INTERVAL_MULTIPLIER.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.MAX_RETRY_INTERVAL.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.LOAD_BALANCING_CLASS_NAME.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.USE_GLOBAL_POOLS.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.marshallAsElement(factory, false, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.marshallAsElement(factory, false, (XMLStreamWriter)writer);
        CommonAttributes.GROUP_ID.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeJmsQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            String name = prop.getName();
            ModelNode queue = prop.getValue();
            if (!queue.isDefined()) continue;
            writer.writeStartElement(Element.JMS_QUEUE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            CommonAttributes.ENTRIES.marshallAsElement(queue, (XMLStreamWriter)writer);
            CommonAttributes.DURABLE.marshallAsElement(queue, (XMLStreamWriter)writer);
            CommonAttributes.SELECTOR.marshallAsElement(queue, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeTopics(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (Property prop : node.asPropertyList()) {
            String name = prop.getName();
            ModelNode topic = prop.getValue();
            if (!topic.isDefined()) continue;
            writer.writeStartElement(Element.JMS_TOPIC.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            CommonAttributes.ENTRIES.marshallAsElement(topic, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeTransactionTypeAttribute(XMLExtendedStreamWriter writer, Element attr, ModelNode value) throws XMLStreamException {
        String xaType = value.asString();
        String txSupport = "LocalTransaction".equals(xaType) ? "local" : ("none".equals(xaType) ? "none" : "xa");
        writer.writeAttribute(attr.getLocalName(), txSupport);
    }

    private boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    static void processJMSTopic(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        topic.get("operation").set("add");
        topic.get("address").set(address).add("jms-topic", name);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    Location location = reader.getLocation();
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, topic, location);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(topic);
    }

    static void processJMSQueue(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode queue = new ModelNode();
        queue.get("operation").set("add");
        queue.get("address").set(address).add("jms-queue", name);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    Location location = reader.getLocation();
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, queue, location);
                    continue block5;
                }
                case SELECTOR: {
                    if (queue.has(CommonAttributes.SELECTOR.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
                case DURABLE: {
                    if (queue.has(CommonAttributes.DURABLE.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(queue);
    }

    static void processConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("connection-factory", name);
        updates.add(MessagingSubsystemParser.createConnectionFactory(reader, connectionFactory));
    }

    static void processPooledConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("pooled-connection-factory", name);
        updates.add(MessagingSubsystemParser.createConnectionFactory(reader, connectionFactory));
    }

    static ModelNode processJmsConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case CONNECTOR_NAME: {
                        name = value.trim();
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.CONNECTOR_NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.CONNECTOR_REF) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode connector = connectors.get(name).setEmptyObject();
        }
        return connectors;
    }

    private static ModelNode createConnectionFactory(XMLExtendedStreamReader reader, ModelNode connectionFactory) throws XMLStreamException {
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    Location location = reader.getLocation();
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, connectionFactory, location);
                    continue block13;
                }
                case CONNECTORS: {
                    connectionFactory.get("connector").set(MessagingSubsystemParser.processJmsConnectors(reader));
                    continue block13;
                }
                case ENTRIES: {
                    Element local;
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        Location location = reader.getLocation();
                        String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                        JndiEntriesAttribute.CONNECTION_FACTORY.parseAndAddParameterElement(entry, connectionFactory, location);
                    }
                    continue block13;
                }
                case INBOUND_CONFIG: {
                    Element local;
                    block15: while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        switch (local) {
                            case USE_JNDI: 
                            case JNDI_PARAMS: 
                            case USE_LOCAL_TX: 
                            case SETUP_ATTEMPTS: 
                            case SETUP_INTERVAL: {
                                MessagingSubsystemParser.handleElementText(reader, local, connectionFactory);
                                continue block15;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block13;
                }
                case TRANSACTION: {
                    String txType = reader.getAttributeValue(0);
                    if (txType != null) {
                        connectionFactory.get("transaction").set(txType);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block13;
                }
                case CONFIRMATION_WINDOW_SIZE: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case DISCOVERY_INITIAL_WAIT_TIMEOUT: 
                case CLIENT_FAILURE_CHECK_PERIOD: 
                case CONNECTION_TTL: 
                case CALL_TIMEOUT: 
                case CONSUMER_WINDOW_SIZE: 
                case CONSUMER_MAX_RATE: 
                case PRODUCER_WINDOW_SIZE: 
                case PRODUCER_MAX_RATE: 
                case CACHE_LARGE_MESSAGE_CLIENT: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case CLIENT_ID: 
                case DUPS_OK_BATCH_SIZE: 
                case TRANSACTION_BATH_SIZE: 
                case BLOCK_ON_ACK: 
                case BLOCK_ON_NON_DURABLE_SEND: 
                case BLOCK_ON_DURABLE_SEND: 
                case AUTO_GROUP: 
                case PRE_ACK: 
                case MAX_RETRY_INTERVAL: 
                case FAILOVER_ON_INITIAL_CONNECTION: 
                case LOAD_BALANCING_CLASS_NAME: 
                case USE_GLOBAL_POOLS: 
                case GROUP_ID: {
                    MessagingSubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block13;
                }
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "default", connectionFactory);
                    continue block13;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: 
                case RECONNECT_ATTEMPTS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "connection", connectionFactory);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return connectionFactory;
    }

    static {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            SIMPLE_ROOT_RESOURCE_ELEMENTS.add(Element.forName(attr.getXmlName()));
        }
    }
}

