/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.RemoveRecoveryInfoCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.Util;

public class ReplicableCommandExternalizer
extends AbstractExternalizer<ReplicableCommand> {
    private RemoteCommandsFactory cmdFactory;

    public void inject(RemoteCommandsFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    @Override
    public void writeObject(ObjectOutput output, ReplicableCommand command) throws IOException {
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.getModuleCommands();
        if (moduleCommands.contains(command.getClass())) {
            output.writeByte(1);
        } else {
            output.writeByte(0);
        }
        output.writeShort(command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        UnsignedNumeric.writeUnsignedInt(output, numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Object arg = args[i];
            if (arg instanceof DeltaAware) {
                DeltaAware dw = (DeltaAware)arg;
                output.writeObject(dw.delta());
                continue;
            }
            output.writeObject(arg);
        }
    }

    @Override
    public ReplicableCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        short methodId = input.readShort();
        int numArgs = UnsignedNumeric.readUnsignedInt(input);
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        return this.cmdFactory.fromStream((byte)methodId, args, type);
    }

    @Override
    public Integer getId() {
        return 62;
    }

    @Override
    public Set<Class<? extends ReplicableCommand>> getTypeClasses() {
        Set<Class<? extends ReplicableCommand>> coreCommands = Util.asSet(MapReduceCommand.class, DistributedExecuteCommand.class, LockControlCommand.class, RehashControlCommand.class, StateTransferControlCommand.class, GetKeyValueCommand.class, ClusteredGetCommand.class, MultipleRpcCommand.class, SingleRpcCommand.class, CommitCommand.class, PrepareCommand.class, RollbackCommand.class, ClearCommand.class, EvictCommand.class, InvalidateCommand.class, InvalidateL1Command.class, PutKeyValueCommand.class, PutMapCommand.class, RemoveCommand.class, ReplaceCommand.class, RemoveCacheCommand.class, RemoveRecoveryInfoCommand.class, GetInDoubtTransactionsCommand.class, GetInDoubtTxInfoCommand.class, CompleteTransactionCommand.class);
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.getModuleCommands();
        if (moduleCommands != null && !moduleCommands.isEmpty()) {
            coreCommands.addAll(moduleCommands);
        }
        return coreCommands;
    }

    private Collection<Class<? extends ReplicableCommand>> getModuleCommands() {
        return ModuleProperties.moduleCommands(null);
    }
}

