/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.LogFactory;

public class InvocationContextInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private ComponentRegistry componentRegistry;
    private TransactionTable txTable;

    @Inject
    public void init(TransactionManager tm, ComponentRegistry componentRegistry, TransactionTable txTable) {
        this.tm = tm;
        this.componentRegistry = componentRegistry;
        this.txTable = txTable;
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand lcc) throws Throwable {
        Object retval = this.handleAll(ctx, lcc);
        return retval == null ? Boolean.valueOf(false) : retval;
    }

    /*
     * Loose catch block
     */
    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        boolean suppressExceptions = false;
        ComponentStatus status = this.componentRegistry.getStatus();
        if (command.ignoreCommandOnStatus(status)) {
            this.log.debugf("Status: %s : Ignoring %s command", (Object)status, command);
            return null;
        }
        if (status.isTerminated()) {
            throw new IllegalStateException(String.format("%s is in 'TERMINATED' state and so it does not accept new invocations. Either restart it or recreate the cache container.", this.getCacheNamePrefix()));
        }
        if (this.stoppingAndNotAllowed(status, ctx)) {
            throw new IllegalStateException(String.format("%s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.", this.getCacheNamePrefix()));
        }
        LogFactory.pushNDC(this.componentRegistry.getCacheName(), this.trace);
        try {
            Object object;
            if (this.trace) {
                this.log.tracef("Invoked with command %s and InvocationContext [%s]", command, ctx);
            }
            if (ctx == null) {
                throw new IllegalStateException("Null context not allowed!!");
            }
            if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
                suppressExceptions = true;
            }
            try {
                object = this.invokeNextInterceptor(ctx, command);
            }
            catch (Throwable th) {
                block18: {
                    if (!suppressExceptions) break block18;
                    this.log.trace("Exception while executing code, failing silently...", th);
                    Object var6_7 = null;
                    ctx.reset();
                    LogFactory.popNDC(this.trace);
                    return var6_7;
                }
                this.log.executionError(th);
                if (ctx.isInTxScope() && ctx.isOriginLocal()) {
                    if (this.trace) {
                        this.log.trace("Transaction marked for rollback as exception was received.");
                    }
                    this.markTxForRollbackAndRethrow(ctx, th);
                    throw new IllegalStateException("This should not be reached");
                }
                throw th;
                {
                    catch (Throwable throwable) {
                        ctx.reset();
                        throw throwable;
                    }
                }
            }
            ctx.reset();
            return object;
        }
        finally {
            LogFactory.popNDC(this.trace);
        }
    }

    private String getCacheNamePrefix() {
        String cacheName = this.componentRegistry.getCacheName();
        String prefix = "Cache '" + cacheName + "'";
        if (cacheName.equals("___defaultcache")) {
            prefix = "Default cache";
        }
        return prefix;
    }

    private boolean stoppingAndNotAllowed(ComponentStatus status, InvocationContext ctx) throws Exception {
        return status.isStopping() && (!ctx.isInTxScope() || !this.isOngoingTransaction(ctx));
    }

    private Object markTxForRollbackAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        Transaction transaction;
        if (ctx.isOriginLocal() && ctx.isInTxScope() && (transaction = this.tm.getTransaction()) != null && this.isValidRunningTx(transaction)) {
            transaction.setRollbackOnly();
        }
        throw te;
    }

    public boolean isValidRunningTx(Transaction tx) throws Exception {
        int status;
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new CacheException("Unexpected!", e);
        }
        return status == 0 || status == 7;
    }

    private boolean isOngoingTransaction(InvocationContext ctx) throws SystemException {
        return ctx.isInTxScope() && (this.txTable.containsLocalTx(this.tm.getTransaction()) || this.txTable.containRemoteTx(((TxInvocationContext)ctx).getGlobalTransaction()));
    }
}

