/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.RehashInProgressException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.TxInterceptor;

public class DistTxInterceptor
extends TxInterceptor {
    DistributionManager dm;
    ReplayCommandVisitor replayCommandVisitor = new ReplayCommandVisitor();
    private CommandsFactory commandsFactory;

    @Inject
    public void injectDistributionManager(DistributionManager dm, CommandsFactory commandsFactory) {
        this.dm = dm;
        this.commandsFactory = commandsFactory;
    }

    @Override
    protected VisitableCommand getCommandToReplay(VisitableCommand command) {
        try {
            return (VisitableCommand)command.acceptVisitor(null, this.replayCommandVisitor);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand cmd) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, cmd)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitPrepareCommand(ctx, cmd);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand cmd) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, cmd)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitRollbackCommand(ctx, cmd);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand cmd) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, cmd)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitCommitCommand(ctx, cmd);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand cmd) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, cmd)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitLockControlCommand(ctx, cmd);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, command)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitPutKeyValueCommand(ctx, command);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, command)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitRemoveCommand(ctx, command);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, command)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitReplaceCommand(ctx, command);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, command)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitClearCommand(ctx, command);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.dm.getTransactionLogger().beforeCommand(ctx, command)) {
            throw new RehashInProgressException("Timed out waiting for the transaction lock");
        }
        try {
            Object object = super.visitPutMapCommand(ctx, command);
            return object;
        }
        finally {
            this.dm.getTransactionLogger().afterCommand(ctx, command);
        }
    }

    class ReplayCommandVisitor
    extends AbstractVisitor {
        ReplayCommandVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : command.getMap().entrySet()) {
                if (!DistTxInterceptor.this.dm.getLocality(entry.getKey()).isLocal()) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            if (newMap.isEmpty()) {
                return null;
            }
            if (newMap.size() == command.getMap().size()) {
                return command;
            }
            return DistTxInterceptor.this.commandsFactory.buildPutMapCommand(newMap, command.getLifespanMillis(), command.getMaxIdleTimeMillis(), ctx.getFlags());
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ignored, PutKeyValueCommand command) {
            return this.visitDataWriteCommand(command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ignored, RemoveCommand command) {
            return this.visitDataWriteCommand(command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ignored, ReplaceCommand command) {
            return this.visitDataWriteCommand(command);
        }

        private VisitableCommand visitDataWriteCommand(DataWriteCommand command) {
            return DistTxInterceptor.this.dm.getLocality(command.getKey()).isLocal() ? command : null;
        }

        @Override
        public Object handleDefault(InvocationContext ignored, VisitableCommand command) {
            return command;
        }
    }
}

