/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Units;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    private AtomicLong hitTimes = new AtomicLong(0L);
    private AtomicLong missTimes = new AtomicLong(0L);
    private AtomicLong storeTimes = new AtomicLong(0L);
    private AtomicLong hits = new AtomicLong(0L);
    private AtomicLong misses = new AtomicLong(0L);
    private AtomicLong stores = new AtomicLong(0L);
    private AtomicLong evictions = new AtomicLong(0L);
    private AtomicLong start = new AtomicLong(System.currentTimeMillis());
    private AtomicLong reset = new AtomicLong(this.start.get());
    private AtomicLong removeHits = new AtomicLong(0L);
    private AtomicLong removeMisses = new AtomicLong(0L);
    private DataContainer dataContainer;

    @Inject
    public void setDependencies(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        this.evictions.incrementAndGet();
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (retval == null) {
            this.missTimes.getAndAdd(t2 - t1);
            this.misses.incrementAndGet();
        } else {
            this.hitTimes.getAndAdd(t2 - t1);
            this.hits.incrementAndGet();
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map<Object, Object> data = command.getMap();
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (data != null && !data.isEmpty()) {
            this.storeTimes.getAndAdd(t2 - t1);
            this.stores.getAndAdd(data.size());
        }
        return retval;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        this.storeTimes.getAndAdd(t2 - t1);
        this.stores.incrementAndGet();
        return retval;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (retval == null) {
            this.removeMisses.incrementAndGet();
        } else {
            this.removeHits.incrementAndGet();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of cache attribute hits")
    @Metric(displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.hits.get();
    }

    @ManagedAttribute(description="Number of cache attribute misses")
    @Metric(displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.misses.get();
    }

    @ManagedAttribute(description="Number of cache removal hits")
    @Metric(displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.removeHits.get();
    }

    @ManagedAttribute(description="Number of cache removals where keys were not found")
    @Metric(displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.removeMisses.get();
    }

    @ManagedAttribute(description="number of cache attribute put operations")
    @Metric(displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.stores.get();
    }

    @ManagedAttribute(description="Number of cache eviction operations")
    @Metric(displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.evictions.get();
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache")
    @Metric(displayName="Hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        long hitsL = this.hits.get();
        double total = hitsL + this.misses.get();
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache")
    @Metric(displayName="Read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        if (this.stores.get() == 0L) {
            return 0.0;
        }
        return (double)(this.hits.get() + this.misses.get()) / (double)this.stores.get();
    }

    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache")
    @Metric(displayName="Average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long total = this.hits.get() + this.misses.get();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.get() + this.missTimes.get()) / total;
    }

    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache")
    @Metric(displayName="Average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        if (this.stores.get() == 0L) {
            return 0L;
        }
        return this.storeTimes.get() / this.stores.get();
    }

    @ManagedAttribute(description="Number of entries currently in the cache")
    @Metric(displayName="Number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.dataContainer.size();
    }

    @ManagedAttribute(description="Number of seconds since cache started")
    @Metric(displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getElapsedTime() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.start.get());
    }

    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset")
    @Metric(displayName="Seconds since cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.reset.get());
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.stores.set(0L);
        this.evictions.set(0L);
        this.hitTimes.set(0L);
        this.missTimes.set(0L);
        this.storeTimes.set(0L);
        this.removeHits.set(0L);
        this.removeMisses.set(0L);
        this.reset.set(System.currentTimeMillis());
    }
}

