/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.hash.Hash;

public class DefaultConsistentHash
extends AbstractWheelConsistentHash {
    public DefaultConsistentHash() {
    }

    public DefaultConsistentHash(Hash hash) {
        this.setHashFunction(hash);
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        return this.locateInternal(key, replCount, null);
    }

    @Override
    public boolean isKeyLocalToAddress(Address target, Object key, int replCount) {
        return this.locateInternal(key, replCount, target).contains(target);
    }

    private List<Address> locateInternal(Object key, int replCount, Address target) {
        int actualReplCount = Math.min(replCount, this.caches.size());
        int normalizedHash = this.getNormalizedHash(this.getGrouping(key));
        ArrayList<Address> owners = new ArrayList<Address>(replCount);
        Iterator<Map.Entry<Integer, Address>> it = this.getPositionsIterator(normalizedHash);
        while (it.hasNext()) {
            Address a = it.next().getValue();
            if (this.isVirtualNodesEnabled() && owners.contains(a)) continue;
            if (a == target) {
                return null;
            }
            owners.add(a);
            if (owners.size() < actualReplCount) continue;
            return owners;
        }
        return owners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.hashFunction != null ? !this.hashFunction.equals(that.hashFunction) : that.hashFunction != null) {
            return false;
        }
        if (this.numVirtualNodes != that.numVirtualNodes) {
            return false;
        }
        return !(this.caches != null ? !((Object)this.caches).equals(that.caches) : that.caches != null);
    }

    public int hashCode() {
        int result = this.caches != null ? ((Object)this.caches).hashCode() : 0;
        result = 31 * result + this.hashFunction.hashCode();
        result = 31 * result + this.numVirtualNodes;
        return result;
    }

    public static class Externalizer
    extends AbstractWheelConsistentHash.Externalizer<DefaultConsistentHash> {
        @Override
        protected DefaultConsistentHash instance() {
            return new DefaultConsistentHash();
        }

        @Override
        public Integer getId() {
            return 51;
        }

        @Override
        public Set<Class<? extends DefaultConsistentHash>> getTypeClasses() {
            return Util.asSet(DefaultConsistentHash.class);
        }
    }
}

