/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class RehashTask
implements Callable<Void> {
    protected DistributionManager distributionManager;
    protected RpcManager rpcManager;
    protected Configuration configuration;
    protected CommandsFactory cf;
    protected DataContainer dataContainer;
    protected final Address self;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.log.isTraceEnabled();

    protected RehashTask(DistributionManagerImpl distributionManager, RpcManager rpcManager, Configuration configuration, CommandsFactory cf, DataContainer dataContainer) {
        this.distributionManager = distributionManager;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.self = rpcManager.getAddress();
    }

    @Override
    public Void call() throws Exception {
        try {
            this.performRehash();
        }
        catch (InterruptedException e) {
            this.log.debugf("Rehash was interrupted because the cache is shutting down", new Object[0]);
        }
        catch (Throwable th) {
            this.log.errorDuringRehash(th);
        }
        return null;
    }

    protected abstract void performRehash() throws Exception;

    protected Collection<Address> coordinator() {
        return Collections.singleton(this.rpcManager.getTransport().getCoordinator());
    }
}

