/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import javax.transaction.xa.Xid;
import org.infinispan.commands.remote.recovery.RecoveryCommand;
import org.infinispan.context.InvocationContext;

public class RemoveRecoveryInfoCommand
extends RecoveryCommand {
    public static final int COMMAND_ID = 22;
    private Xid xid;
    private long internalId;

    public RemoveRecoveryInfoCommand(Xid xid, String cacheName) {
        this.xid = xid;
        this.cacheName = cacheName;
    }

    public RemoveRecoveryInfoCommand() {
    }

    public RemoveRecoveryInfoCommand(long internalId, String cacheName) {
        this.internalId = internalId;
        this.cacheName = cacheName;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.xid != null) {
            this.recoveryManager.removeRecoveryInformation(this.xid);
        } else {
            this.recoveryManager.removeRecoveryInformation(this.internalId);
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 22;
    }

    @Override
    public Object[] getParameters() {
        Object[] result = new Object[]{this.xid != null ? this.xid : Long.valueOf(this.internalId), this.cacheName};
        return result;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 22) {
            throw new IllegalArgumentException("Wrong command id. Received " + commandId + " and expected " + 22);
        }
        if (parameters[0] instanceof Xid) {
            this.xid = (Xid)parameters[0];
        } else {
            this.internalId = (Long)parameters[0];
        }
        this.cacheName = (String)parameters[1];
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", internalId=" + this.internalId + ", cacheName=" + this.cacheName + "} ";
    }
}

