/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetKeyValueCommand
extends AbstractDataCommand {
    public static final byte COMMAND_ID = 4;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheNotifier notifier;
    private boolean returnCacheEntry;

    public GetKeyValueCommand(Object key, CacheNotifier notifier, Set<Flag> flags) {
        this.key = key;
        this.notifier = notifier;
        this.flags = flags;
    }

    public GetKeyValueCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    public void setReturnCacheEntry(boolean returnCacheEntry) {
        this.returnCacheEntry = returnCacheEntry;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Object result;
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            if (trace) {
                log.trace("Entry not found");
            }
            return null;
        }
        if (entry.isRemoved()) {
            if (trace) {
                log.tracef("Entry has been deleted and is of type %s", entry.getClass().getSimpleName());
            }
            return null;
        }
        Object value = entry.getValue();
        this.notifier.notifyCacheEntryVisited(this.key, value, true, ctx);
        Object object = result = this.returnCacheEntry ? entry : value;
        if (trace) {
            log.tracef("Found value %s", result);
        }
        this.notifier.notifyCacheEntryVisited(this.key, value, false, ctx);
        return result;
    }

    @Override
    public byte getCommandId() {
        return 4;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 4) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.flags = parameters.length > 1 ? parameters[1] : Collections.EMPTY_SET;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.flags};
    }
}

