/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.value.Value;

public interface ServiceBuilder<T> {
    public ServiceBuilder<T> addAliases(ServiceName ... var1);

    public ServiceBuilder<T> setInitialMode(ServiceController.Mode var1);

    public ServiceBuilder<T> addDependencies(ServiceName ... var1);

    public ServiceBuilder<T> addDependencies(DependencyType var1, ServiceName ... var2);

    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> var1);

    public ServiceBuilder<T> addDependencies(DependencyType var1, Iterable<ServiceName> var2);

    public ServiceBuilder<T> addDependency(ServiceName var1);

    public ServiceBuilder<T> addDependency(DependencyType var1, ServiceName var2);

    public ServiceBuilder<T> addDependency(ServiceName var1, Injector<Object> var2);

    public ServiceBuilder<T> addDependency(DependencyType var1, ServiceName var2, Injector<Object> var3);

    public <I> ServiceBuilder<T> addDependency(ServiceName var1, Class<I> var2, Injector<I> var3);

    public <I> ServiceBuilder<T> addDependency(DependencyType var1, ServiceName var2, Class<I> var3, Injector<I> var4);

    public <I> ServiceBuilder<T> addInjection(Injector<? super I> var1, I var2);

    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> var1, Value<I> var2);

    public ServiceBuilder<T> addInjection(Injector<? super T> var1);

    public ServiceBuilder<T> addListener(ServiceListener<? super T> var1);

    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... var1);

    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> var1);

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance var1, ServiceListener<? super T> var2);

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance var1, ServiceListener<? super T> ... var2);

    public ServiceBuilder<T> addListener(ServiceListener.Inheritance var1, Collection<? extends ServiceListener<? super T>> var2);

    public ServiceController<T> install() throws ServiceRegistryException, IllegalStateException;

    public static enum DependencyType {
        REQUIRED,
        OPTIONAL;

    }
}

