/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;

final class ManagedReferenceLifecycleMethodInterceptor
implements Interceptor {
    private final AtomicReference<ManagedReference> instanceRef;
    private final Method method;
    private final boolean withContext;
    private final boolean changeMethod;

    ManagedReferenceLifecycleMethodInterceptor(AtomicReference<ManagedReference> instanceRef, Method method, boolean changeMethod) {
        this.changeMethod = changeMethod;
        this.method = method;
        this.instanceRef = instanceRef;
        this.withContext = method.getParameterTypes().length == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        ManagedReference reference = this.instanceRef.get();
        Object instance = reference.getInstance();
        try {
            Method method = this.method;
            if (!this.withContext) {
                method.invoke(instance, null);
                return context.proceed();
            }
            if (!this.changeMethod) {
                return method.invoke(instance, context.getInvocationContext());
            }
            Method oldMethod = context.getMethod();
            context.setMethod(method);
            try {
                Object object = method.invoke(instance, context.getInvocationContext());
                return object;
            }
            finally {
                context.setMethod(oldMethod);
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }
}

