/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfigurator;
import org.jboss.as.ee.component.LazyResourceInjection;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;

public final class EEModuleDescription {
    private final String applicationName;
    private volatile String moduleName;
    private final Map<String, ComponentDescription> componentsByName = new HashMap<String, ComponentDescription>();
    private final Map<String, List<ComponentDescription>> componentsByClassName = new HashMap<String, List<ComponentDescription>>();
    private final Map<String, List<LazyResourceInjection>> lazyResourceInjections = new HashMap<String, List<LazyResourceInjection>>();
    private InjectedEENamespaceContextSelector namespaceContextSelector;
    private final Deque<EEModuleConfigurator> moduleConfigurators = new ArrayDeque<EEModuleConfigurator>();

    public EEModuleDescription(String applicationName, String moduleName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    public void addLazyResourceInjection(LazyResourceInjection injection) {
        String name = injection.getLocalContextName();
        if (!name.startsWith("java:")) {
            List<LazyResourceInjection> list = this.lazyResourceInjections.get("java:comp/env/" + name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put("java:comp/env/" + name, list);
            }
            list.add(injection);
            list = this.lazyResourceInjections.get("java:module/env/" + name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put("java:module/env/" + name, list);
            }
            list.add(injection);
        } else {
            List<LazyResourceInjection> list = this.lazyResourceInjections.get(name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put(name, list);
            }
            list.add(injection);
        }
    }

    public Map<String, List<LazyResourceInjection>> getLazyResourceInjections() {
        return this.lazyResourceInjections;
    }

    public void addComponent(ComponentDescription description) {
        String componentName = description.getComponentName();
        String componentClassName = description.getComponentClassName();
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("componentClassName is null");
        }
        if (this.componentsByName.containsKey(componentName)) {
            throw new IllegalArgumentException("A component named '" + componentName + "' is already defined in this module");
        }
        this.componentsByName.put(componentName, description);
        List<ComponentDescription> list = this.componentsByClassName.get(componentClassName);
        if (list == null) {
            list = new ArrayList<ComponentDescription>(1);
            this.componentsByClassName.put(componentClassName, list);
        }
        list.add(description);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean hasComponent(String name) {
        return this.componentsByName.containsKey(name);
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ComponentDescription getComponentByName(String name) {
        return this.componentsByName.get(name);
    }

    public List<ComponentDescription> getComponentsByClassName(String className) {
        List<ComponentDescription> ret = this.componentsByClassName.get(className);
        return ret == null ? Collections.emptyList() : ret;
    }

    public Collection<ComponentDescription> getComponentDescriptions() {
        return this.componentsByName.values();
    }

    public Deque<EEModuleConfigurator> getConfigurators() {
        return this.moduleConfigurators;
    }

    public InjectedEENamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public void setNamespaceContextSelector(InjectedEENamespaceContextSelector namespaceContextSelector) {
        this.namespaceContextSelector = namespaceContextSelector;
    }
}

