/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemProviders;
import org.jboss.as.threads.ThreadsSubsystemThreadPoolOperationUtils;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class UnboundedQueueThreadPoolAdd
implements OperationStepHandler,
DescriptionProvider {
    static final UnboundedQueueThreadPoolAdd INSTANCE = new UnboundedQueueThreadPoolAdd();

    public void execute(OperationContext context, ModelNode operation) {
        final ThreadsSubsystemThreadPoolOperationUtils.BaseOperationParameters params = ThreadsSubsystemThreadPoolOperationUtils.parseUnboundedQueueThreadPoolOperationParameters(operation);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        model.get("name").set(name);
        if (params.getThreadFactory() != null) {
            model.get("thread-factory").set(params.getThreadFactory());
        }
        if (params.getProperties() != null && params.getProperties().asList().size() > 0) {
            model.get("properties").set(params.getProperties());
        }
        if (params.getMaxThreads() != null) {
            model.get("max-threads").set(operation.get("max-threads"));
        }
        if (params.getKeepAliveTime() != null) {
            model.get("keepalive-time").set(operation.get("keepalive-time"));
        }
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    ServiceTarget target = context.getServiceTarget();
                    ServiceName serviceName = ThreadsServices.executorName(params.getName());
                    UnboundedQueueThreadPoolService service = new UnboundedQueueThreadPoolService(params.getMaxThreads().getScaledCount(), params.getKeepAliveTime());
                    ServiceBuilder serviceBuilder = target.addService(serviceName, (Service)service);
                    ThreadsSubsystemThreadPoolOperationUtils.addThreadFactoryDependency(params.getThreadFactory(), serviceName, serviceBuilder, service.getThreadFactoryInjector(), target, params.getName() + "-threads");
                    serviceBuilder.addListener((ServiceListener)verificationHandler);
                    serviceBuilder.install();
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.removeService(serviceName);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return ThreadsSubsystemProviders.ADD_UNBOUNDED_QUEUE_THREAD_POOL_DESC.getModelDescription(locale);
    }
}

