/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.metadata;

import java.io.Serializable;

public class IORSecurityConfigMetadata
implements Serializable {
    private static final long serialVersionUID = -3341898910508715334L;
    private TransportConfig transportConfig = new TransportConfig();
    private AsContext asContext = new AsContext();
    private SasContext sasContext = new SasContext();

    public TransportConfig getTransportConfig() {
        return this.transportConfig;
    }

    public void setTransportConfig(TransportConfig config) {
        this.transportConfig = config;
    }

    public AsContext getAsContext() {
        return this.asContext;
    }

    public void setAsContext(AsContext context) {
        this.asContext = context;
    }

    public SasContext getSasContext() {
        return this.sasContext;
    }

    public void setSasContext(SasContext context) {
        this.sasContext = context;
    }

    public String toString() {
        return "[transport-config=" + this.transportConfig + ", as-context=" + this.asContext + ", sas-context=" + this.sasContext + "]";
    }

    public class SasContext {
        public static final String CALLER_PROPAGATION_NONE = "NONE";
        public static final String CALLER_PROPAGATION_SUPPORTED = "SUPPORTED";
        private final String callerPropagation;

        private SasContext() {
            this.callerPropagation = CALLER_PROPAGATION_NONE;
        }

        public SasContext(String callerPropagation) {
            if (callerPropagation == null) {
                throw new IllegalArgumentException("Null callerPropagation");
            }
            if (CALLER_PROPAGATION_NONE.equalsIgnoreCase(callerPropagation)) {
                this.callerPropagation = CALLER_PROPAGATION_NONE;
            } else if (CALLER_PROPAGATION_SUPPORTED.equalsIgnoreCase(callerPropagation)) {
                this.callerPropagation = CALLER_PROPAGATION_SUPPORTED;
            } else {
                throw new IllegalArgumentException("Unknown sascontext callerPropagtion: " + callerPropagation);
            }
        }

        public String getCallerPropagation() {
            return this.callerPropagation;
        }

        public boolean isCallerPropagationSupported() {
            return CALLER_PROPAGATION_SUPPORTED.equalsIgnoreCase(this.callerPropagation);
        }

        public String toString() {
            return "[caller-propagation=" + this.callerPropagation + "]";
        }
    }

    public class AsContext {
        public static final String AUTH_METHOD_USERNAME_PASSWORD = "USERNAME_PASSWORD";
        public static final String AUTH_METHOD_NONE = "NONE";
        private final String authMethod;
        private final String realm;
        private final boolean required;

        private AsContext() {
            this.authMethod = AUTH_METHOD_USERNAME_PASSWORD;
            this.realm = "default";
            this.required = false;
        }

        public AsContext(String authMethod, String realm, boolean required) {
            if (authMethod == null) {
                throw new IllegalArgumentException("Null authMethod");
            }
            if (AUTH_METHOD_NONE.equalsIgnoreCase(authMethod)) {
                this.authMethod = AUTH_METHOD_NONE;
            } else if (AUTH_METHOD_USERNAME_PASSWORD.equalsIgnoreCase(authMethod)) {
                this.authMethod = AUTH_METHOD_USERNAME_PASSWORD;
            } else {
                throw new IllegalArgumentException("Unknown ascontext authMethod: " + authMethod);
            }
            if (realm == null) {
                throw new IllegalArgumentException("Null realm");
            }
            this.realm = realm;
            this.required = required;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "[auth-method=" + this.authMethod + ", realm=" + this.realm + ", required=" + this.required + "]";
        }
    }

    public class TransportConfig {
        public static final String INTEGRITY_NONE = "NONE";
        public static final String INTEGRITY_SUPPORTED = "SUPPORTED";
        public static final String INTEGRITY_REQUIRED = "REQUIRED";
        public static final String CONFIDENTIALITY_NONE = "NONE";
        public static final String CONFIDENTIALITY_SUPPORTED = "SUPPORTED";
        public static final String CONFIDENTIALITY_REQUIRED = "REQUIRED";
        public static final String DETECT_MISORDERING_NONE = "NONE";
        public static final String DETECT_MISORDERING_SUPPORTED = "SUPPORTED";
        public static final String DETECT_MISORDERING_REQUIRED = "REQUIRED";
        public static final String DETECT_REPLAY_NONE = "NONE";
        public static final String DETECT_REPLAY_SUPPORTED = "SUPPORTED";
        public static final String DETECT_REPLAY_REQUIRED = "REQUIRED";
        public static final String ESTABLISH_TRUST_IN_TARGET_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_TARGET_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_CLIENT_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_REQUIRED = "REQUIRED";
        private final String integrity;
        private final String confidentiality;
        private final String detectMisordering;
        private final String detectReplay;
        private final String establishTrustInTarget;
        private final String establishTrustInClient;

        private TransportConfig() {
            this.integrity = "SUPPORTED";
            this.confidentiality = "SUPPORTED";
            this.establishTrustInTarget = "SUPPORTED";
            this.establishTrustInClient = "SUPPORTED";
            this.detectMisordering = "SUPPORTED";
            this.detectReplay = "SUPPORTED";
        }

        public TransportConfig(String integrity, String confidentiality, String establishTrustInTarget, String establishTrustInClient, String detectMisordering, String detectReplay) {
            if (integrity == null) {
                throw new IllegalArgumentException("Null integrity");
            }
            if ("NONE".equalsIgnoreCase(integrity)) {
                this.integrity = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(integrity)) {
                this.integrity = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(integrity)) {
                this.integrity = "REQUIRED";
            } else {
                throw new IllegalArgumentException("Unknown transport integrity: " + integrity);
            }
            if (confidentiality == null) {
                throw new IllegalArgumentException("Null confidentiality");
            }
            if ("NONE".equalsIgnoreCase(confidentiality)) {
                this.confidentiality = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(confidentiality)) {
                this.confidentiality = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(confidentiality)) {
                this.confidentiality = "REQUIRED";
            } else {
                throw new IllegalArgumentException("Unknown transport confidentiality: " + confidentiality);
            }
            if (establishTrustInTarget == null) {
                throw new IllegalArgumentException("Null establishTrustInTarget");
            }
            if ("NONE".equalsIgnoreCase(establishTrustInTarget)) {
                this.establishTrustInTarget = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(establishTrustInTarget)) {
                this.establishTrustInTarget = "SUPPORTED";
            } else {
                throw new IllegalArgumentException("Unknown transport establishTrustInTarget: " + establishTrustInTarget);
            }
            if (establishTrustInClient == null) {
                throw new IllegalArgumentException("Null establishTrustInClient");
            }
            if ("NONE".equalsIgnoreCase(establishTrustInClient)) {
                this.establishTrustInClient = "NONE";
            } else if ("SUPPORTED".equalsIgnoreCase(establishTrustInClient)) {
                this.establishTrustInClient = "SUPPORTED";
            } else if ("REQUIRED".equalsIgnoreCase(establishTrustInClient)) {
                this.establishTrustInClient = "REQUIRED";
            } else {
                throw new IllegalArgumentException("Unknown transport establishTrustInClient: " + establishTrustInClient);
            }
            if (detectMisordering == null || "SUPPORTED".equalsIgnoreCase(detectMisordering)) {
                this.detectMisordering = "SUPPORTED";
            } else if ("NONE".equalsIgnoreCase(detectMisordering)) {
                this.detectMisordering = "NONE";
            } else if ("REQUIRED".equalsIgnoreCase(detectMisordering)) {
                this.detectMisordering = "REQUIRED";
            } else {
                throw new IllegalArgumentException("Unknown transport detectMisordering: " + detectMisordering);
            }
            if (detectReplay == null || "SUPPORTED".equalsIgnoreCase(detectReplay)) {
                this.detectReplay = "SUPPORTED";
            } else if ("NONE".equalsIgnoreCase(detectReplay)) {
                this.detectReplay = "NONE";
            } else if ("REQUIRED".equalsIgnoreCase(detectReplay)) {
                this.detectReplay = "REQUIRED";
            } else {
                throw new IllegalArgumentException("Unknown transport detectReplay: " + detectReplay);
            }
        }

        public String getIntegrity() {
            return this.integrity;
        }

        public String getConfidentiality() {
            return this.confidentiality;
        }

        public String getDetectMisordering() {
            return this.detectMisordering;
        }

        public String getDetectReplay() {
            return this.detectReplay;
        }

        public String getEstablishTrustInTarget() {
            return this.establishTrustInTarget;
        }

        public String getEstablishTrustInClient() {
            return this.establishTrustInClient;
        }

        public boolean isEstablishTrustInTargetSupported() {
            return "SUPPORTED".equalsIgnoreCase(this.establishTrustInTarget);
        }

        public String toString() {
            return "[integrity=" + this.integrity + ", confidentiality=" + this.confidentiality + ", establish-trust-in-target=" + this.establishTrustInTarget + ", establish-trust-in-client=" + this.establishTrustInClient + ", detect-misordering=" + this.detectMisordering + ", detect-replay=" + this.detectReplay + "]";
        }
    }
}

