/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.jacorb.JacORBAttribute;
import org.jboss.as.jacorb.JacORBElement;
import org.jboss.as.jacorb.ORBInitializer;
import org.jboss.as.jacorb.service.CorbaNamingService;
import org.jboss.as.jacorb.service.CorbaORBService;
import org.jboss.as.jacorb.service.CorbaPOAService;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;

public class JacORBSubsystemAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.jacorb");
    private static final String JACORB_SOCKET_BINDING = "jacorb";
    private static final String JACORB_SSL_SOCKET_BINDING = "jacorb-ssl";
    static final JacORBSubsystemAdd INSTANCE = new JacORBSubsystemAdd();
    private final ParametersValidator jacorbConfigValidator = new ParametersValidator();

    private JacORBSubsystemAdd() {
        ModelTypeValidator optionalObjectTypeValidator = new ModelTypeValidator(ModelType.OBJECT, true);
        this.jacorbConfigValidator.registerValidator(JacORBElement.ORB_CONFIG.getLocalName(), (ParameterValidator)optionalObjectTypeValidator);
        this.jacorbConfigValidator.registerValidator(JacORBElement.POA_CONFIG.getLocalName(), (ParameterValidator)optionalObjectTypeValidator);
        this.jacorbConfigValidator.registerValidator(JacORBElement.INTEROP_CONFIG.getLocalName(), (ParameterValidator)optionalObjectTypeValidator);
        this.jacorbConfigValidator.registerValidator(JacORBElement.SECURITY_CONFIG.getLocalName(), (ParameterValidator)optionalObjectTypeValidator);
        this.jacorbConfigValidator.registerValidator(JacORBElement.PROPERTY_CONFIG.getLocalName(), (ParameterValidator)new ModelTypeValidator(ModelType.LIST, true));
        this.jacorbConfigValidator.registerValidator(JacORBElement.INITIALIZERS_CONFIG.getLocalName(), (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true));
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.jacorbConfigValidator.validate(operation);
        for (JacORBElement configElement : JacORBElement.getRootElements()) {
            String configElementName = configElement.getLocalName();
            if (!operation.hasDefined(configElementName)) continue;
            model.get(configElementName).set(operation.get(configElementName));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        log.info((Object)"Activating JacORB Subsystem");
        EnumSet<ORBInitializer> initializers = this.getORBInitializers(operation);
        Properties props = new Properties();
        this.getConfigurationProperties(operation, props);
        CorbaORBService orbService = new CorbaORBService(initializers, props);
        ServiceBuilder builder = context.getServiceTarget().addService(CorbaORBService.SERVICE_NAME, (Service)orbService);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{JACORB_SOCKET_BINDING}), SocketBinding.class, orbService.getJacORBSocketBindingInjector());
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{JACORB_SSL_SOCKET_BINDING}), SocketBinding.class, orbService.getJacORBSSLSocketBindingInjector());
        builder.addListener((ServiceListener)verificationHandler);
        newControllers.add(builder.setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService rootPOAService = new CorbaPOAService("RootPOA", "poa");
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"rootpoa"}), (Service)rootPOAService).addDependency(CorbaORBService.SERVICE_NAME, ORB.class, rootPOAService.getORBInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService irPOAService = new CorbaPOAService("IRPOA", "irpoa", IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"irpoa"}), (Service)irPOAService).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"rootpoa"}), POA.class, irPOAService.getParentPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaPOAService namingPOAService = new CorbaPOAService("NamingPOA", null, IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        newControllers.add(context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), (Service)namingPOAService).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"rootpoa"}), POA.class, namingPOAService.getParentPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        CorbaNamingService namingService = new CorbaNamingService();
        newControllers.add(context.getServiceTarget().addService(CorbaNamingService.SERVICE_NAME, (Service)namingService).addDependency(CorbaORBService.SERVICE_NAME, ORB.class, namingService.getORBInjector()).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"rootpoa"}), POA.class, namingService.getRootPOAInjector()).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), POA.class, namingService.getNamingPOAInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    private EnumSet<ORBInitializer> getORBInitializers(ModelNode jacorbConfig) throws OperationFailedException {
        if (jacorbConfig.hasDefined(JacORBElement.INITIALIZERS_CONFIG.getLocalName())) {
            String value = jacorbConfig.get(JacORBElement.INITIALIZERS_CONFIG.getLocalName()).asString();
            String[] initializers = value.split(",");
            EnumSet<ORBInitializer> orbInitializers = EnumSet.noneOf(ORBInitializer.class);
            for (String initializer : initializers) {
                ORBInitializer orbInitializer = ORBInitializer.getInitializer(initializer);
                if (orbInitializer == ORBInitializer.UNKNOWN) {
                    throw new OperationFailedException("Unknown ORB initializer", jacorbConfig);
                }
                orbInitializers.add(orbInitializer);
            }
            return orbInitializers;
        }
        return EnumSet.of(ORBInitializer.CODEBASE, ORBInitializer.CSIV2, ORBInitializer.SAS);
    }

    private void getConfigurationProperties(ModelNode node, Properties props) {
        if (node == null || props == null) {
            return;
        }
        for (Property property : node.asPropertyList()) {
            String key = property.getName();
            ModelNode value = property.getValue();
            if (value.getType() == ModelType.OBJECT || value.getType() == ModelType.LIST) {
                this.getConfigurationProperties(value, props);
                continue;
            }
            String jacorbKey = JacORBAttribute.forName(key).getJacORBName();
            if (jacorbKey == null) {
                jacorbKey = key;
            }
            props.setProperty(jacorbKey, value.asString());
        }
    }
}

