/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.AbstractRaOperation;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class RaAdd
extends AbstractRaOperation
implements OperationStepHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        for (String attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
            if (!operation.get(attribute).isDefined()) continue;
            model.get(attribute).set(operation.get(attribute));
        }
    }

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode subModel = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        this.populateModel(operation, subModel);
        ModelNode address = operation.require("address");
        String archive = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        operation.get("archive").set(archive);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    ResourceAdaptersService.ModifiableResourceAdaptors resourceAdapters = RaAdd.this.buildResourceAdaptersObject(operation);
                    ServiceController raService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    ServiceController controller = null;
                    if (raService == null) {
                        controller = serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService(resourceAdapters)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
                    } else {
                        ((ResourceAdaptersService.ModifiableResourceAdaptors)raService.getValue()).addAllResourceAdapters(resourceAdapters.getResourceAdapters());
                    }
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK && controller != null) {
                        context.removeService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

