/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class DataSourceAdd
extends AbstractDataSourceAdd {
    static final DataSourceAdd INSTANCE = new DataSourceAdd();

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) {
        DataSourceAdd.populateAddModel(operation, model, "connection-properties", DataSourcesSubsystemProviders.DATASOURCE_ATTRIBUTE);
    }

    @Override
    protected AbstractDataSourceService createDataSourceService(String jndiName) throws OperationFailedException {
        LocalDataSourceService service = new LocalDataSourceService(jndiName);
        return service;
    }

    @Override
    protected ServiceController<?> startConfigAndAddDependency(ServiceBuilder<?> dataSourceServiceBuilder, AbstractDataSourceService dataSourceService, String jndiName, ServiceTarget serviceTarget, ModelNode operation) throws OperationFailedException {
        DataSource dataSourceConfig;
        try {
            dataSourceConfig = DataSourceModelNodeUtil.from(operation);
        }
        catch (ValidateException e) {
            e.printStackTrace();
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to create DataSource instance for [" + operation + "]\n reason:" + e.getLocalizedMessage()));
        }
        ServiceName dataSourceCongServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        DataSourceConfigService configService = new DataSourceConfigService(dataSourceConfig);
        ServiceController svcController = serviceTarget.addService(dataSourceCongServiceName, (Service)configService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        dataSourceServiceBuilder.addDependency(dataSourceCongServiceName, DataSource.class, ((LocalDataSourceService)dataSourceService).getDataSourceConfigInjector());
        return svcController;
    }
}

