/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Vector;

public class McastSenderTest1_4 {
    public static void main(String[] args) {
        MulticastSocket[] sockets = null;
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        byte[] buf = new byte[]{};
        int ttl = 32;
        AckReceiver ack_receiver = null;
        boolean use_all_interfaces = false;
        int port = 5555;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if ("-help".equals(tmp)) {
                    McastSenderTest1_4.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-ttl".equals(tmp)) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-use_all_interfaces".equals(tmp)) {
                    use_all_interfaces = true;
                    continue;
                }
                McastSenderTest1_4.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock;
            if (use_all_interfaces) {
                Vector<InetAddress> v = new Vector<InetAddress>();
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> e2 = intf.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        bind_addr = e2.nextElement();
                        v.addElement(bind_addr);
                    }
                }
                sockets = new MulticastSocket[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    sock = new MulticastSocket(port);
                    sock.setTimeToLive(ttl);
                    sock.setInterface((InetAddress)v.elementAt(i));
                    sockets[i] = sock;
                    ack_receiver = new AckReceiver(sock);
                    ack_receiver.start();
                }
            } else {
                sockets = new MulticastSocket[]{new MulticastSocket(port)};
                sockets[0].setTimeToLive(ttl);
                if (bind_addr != null) {
                    sockets[0].setInterface(bind_addr);
                }
                ack_receiver = new AckReceiver(sockets[0]);
                ack_receiver.start();
            }
            for (int i = 0; i < sockets.length; ++i) {
                sock = sockets[i];
                if (sock == null) continue;
                System.out.println("Socket #" + (i + 1) + '=' + sock.getLocalAddress() + ':' + sock.getLocalPort() + ", ttl=" + sock.getTimeToLive() + ", bind interface=" + sock.getInterface());
            }
            DataInputStream in = new DataInputStream(System.in);
            while (true) {
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) {
                    System.exit(0);
                }
                buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, mcast_addr, port);
                McastSenderTest1_4.send(packet, sockets);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void send(DatagramPacket packet, MulticastSocket[] sockets) {
        if (packet == null || sockets == null) {
            return;
        }
        for (int i = 0; i < sockets.length; ++i) {
            try {
                if (sockets[i] == null) continue;
                sockets[i].send(packet);
                continue;
            }
            catch (Exception ex) {
                System.err.println("McastSenderTest1_4.send(): " + ex);
            }
        }
    }

    static void help() {
        System.out.println("McastSenderTest1_4 [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>] [-use_all_interfaces]");
    }

    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        AckReceiver(DatagramSocket sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received packet from " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest1_4.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

