/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Event;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Unsupported
public class DELAY
extends Protocol {
    @Property
    int in_delay = 0;
    @Property
    int out_delay = 0;

    public int getInDelay() {
        return this.in_delay;
    }

    public void setInDelay(int in_delay) {
        this.in_delay = in_delay;
    }

    public int getOutDelay() {
        return this.out_delay;
    }

    public void setOutDelay(int out_delay) {
        this.out_delay = out_delay;
    }

    @Override
    public Object up(Event evt) {
        int delay = this.in_delay > 0 ? DELAY.computeDelay(this.in_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info("delaying incoming message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        int delay = this.out_delay > 0 ? DELAY.computeDelay(this.out_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info("delaying outgoing message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
            }
        }
        return this.down_prot.down(evt);
    }

    static int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }
}

