/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PING;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

@Experimental
public class BPING
extends PING
implements Runnable {
    @Property(description="Target address for broadcasts. This should be restricted to the local subnet, e.g. 192.168.1.255")
    protected String dest = "255.255.255.255";
    @Property(description="Port for discovery packets", systemProperty={"jgroups.bping.bind_port"})
    protected int bind_port = 8555;
    @Property(description="Sends discovery packets to ports 8555 to (8555+port_range)")
    protected int port_range = 5;
    protected DatagramSocket sock = null;
    protected volatile Thread receiver = null;
    protected InetAddress dest_addr;

    public int getBindPort() {
        return this.bind_port;
    }

    public void setBindPort(int bind_port) {
        this.bind_port = bind_port;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.dest_addr = InetAddress.getByName(this.dest);
        if (this.log.isDebugEnabled()) {
            this.log.debug("listening on " + this.bind_port);
        }
    }

    @Override
    public void start() throws Exception {
        for (int i = this.bind_port; i < this.bind_port + this.port_range; ++i) {
            try {
                this.sock = this.getSocketFactory().createDatagramSocket("jgroups.bping.sock", i);
                break;
            }
            catch (Throwable t) {
                if (i < this.bind_port + this.port_range - 1) continue;
                throw new RuntimeException("failed to open a port in range [" + this.bind_port + " - " + (this.bind_port + this.port_range) + "]", t);
            }
        }
        this.sock.setBroadcast(true);
        this.startReceiver();
        super.start();
    }

    private void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread(Util.getGlobalThreadGroup(), this, "ReceiverThread");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiver thread started");
            }
        }
    }

    @Override
    public void stop() {
        Util.close(this.sock);
        this.sock = null;
        this.receiver = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendMcastDiscoveryRequest(Message msg) {
        DataOutputStream out = null;
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(128);
            out = new DataOutputStream(out_stream);
            msg.writeTo(out);
            out.flush();
            Buffer buf = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
            this.discovery_reception.reset();
            for (int i = this.bind_port; i < this.bind_port + this.port_range; ++i) {
                DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), this.dest_addr, i);
                this.sock.send(packet);
            }
            this.waitForDiscoveryRequestReception();
            Util.close(out);
        }
        catch (IOException ex) {
            this.log.error("failed sending discovery request", ex);
        }
        finally {
            Util.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        DataInputStream inp = null;
        while (this.sock != null && this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(receive_buf, 0, receive_buf.length);
            try {
                this.sock.receive(packet);
                byte[] data = packet.getData();
                ExposedByteArrayInputStream inp_stream = new ExposedByteArrayInputStream(data, 0, data.length);
                inp = new DataInputStream(inp_stream);
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
            }
            catch (SocketException socketEx) {
                Util.close(inp);
                break;
            }
            catch (Throwable ex) {
                this.log.error("failed receiving packet (from " + packet.getSocketAddress() + ")", ex);
                {
                    catch (Throwable throwable) {
                        Util.close(inp);
                        throw throwable;
                    }
                }
                Util.close(inp);
                continue;
            }
            Util.close(inp);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiver thread terminated");
        }
    }
}

