/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.X509Token;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;

public class AUTH
extends Protocol {
    private AuthToken auth_plugin = null;
    private static final short gms_id = ClassConfigurator.getProtocolId(GMS.class);

    public AUTH() {
        this.name = "AUTH";
    }

    @Property(name="auth_class")
    public void setAuthClass(String class_name) throws Exception {
        Object obj = Class.forName(class_name).newInstance();
        this.auth_plugin = (AuthToken)obj;
        this.auth_plugin.setAuth(this);
    }

    public String getAuthClass() {
        return this.auth_plugin != null ? this.auth_plugin.getClass().getName() : null;
    }

    @Override
    protected List<Object> getConfigurableObjects() {
        LinkedList<Object> retval = new LinkedList<Object>();
        if (this.auth_plugin != null) {
            retval.add(this.auth_plugin);
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.auth_plugin instanceof X509Token) {
            X509Token tmp = (X509Token)this.auth_plugin;
            tmp.setCertificate();
        }
        this.auth_plugin.init();
    }

    @Override
    public Object up(Event evt) {
        GMS.GmsHeader hdr = AUTH.getGMSHeader(evt);
        if (hdr == null) {
            return this.up_prot.up(evt);
        }
        if (hdr.getType() == 1 || hdr.getType() == 11 || hdr.getType() == 6) {
            Message msg = (Message)evt.getArg();
            if (msg.getHeader(this.id) != null && msg.getHeader(this.id) instanceof AuthHeader) {
                AuthHeader authHeader = (AuthHeader)msg.getHeader(this.id);
                if (authHeader != null) {
                    if (this.auth_plugin.authenticate(authHeader.getToken(), msg)) {
                        return this.up_prot.up(evt);
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("failed to validate AuthHeader token");
                    }
                    this.sendRejectionMessage(hdr.getType(), msg.getSrc(), "Authentication failed");
                    return null;
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn("AUTH failed to get valid AuthHeader from Message");
                }
                this.sendRejectionMessage(hdr.getType(), msg.getSrc(), "Failed to find valid AuthHeader in Message");
                return null;
            }
            this.sendRejectionMessage(hdr.getType(), msg.getSrc(), "Failed to find an AuthHeader in Message");
            return null;
        }
        return this.up_prot.up(evt);
    }

    protected void sendRejectionMessage(byte type, Address dest, String error_msg) {
        switch (type) {
            case 1: 
            case 11: {
                this.sendJoinRejectionMessage(dest, error_msg);
                break;
            }
            case 6: {
                this.sendMergeRejectionMessage(dest, error_msg);
                break;
            }
            default: {
                this.log.error("type " + type + " unknown");
            }
        }
    }

    protected void sendJoinRejectionMessage(Address dest, String error_msg) {
        if (dest == null) {
            return;
        }
        Message msg = new Message(dest, null, null);
        JoinRsp joinRes = new JoinRsp(error_msg);
        GMS.GmsHeader gmsHeader = new GMS.GmsHeader(2, joinRes);
        msg.putHeader(gms_id, gmsHeader);
        this.down_prot.down(new Event(1, msg));
    }

    protected void sendMergeRejectionMessage(Address dest, String error_msg) {
        Message msg = new Message(dest, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.setMergeRejected(true);
        msg.putHeader(gms_id, hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("merge response=" + hdr);
        }
        this.down_prot.down(new Event(1, msg));
    }

    @Override
    public Object down(Event evt) {
        GMS.GmsHeader hdr = AUTH.getGMSHeader(evt);
        if (hdr != null && (hdr.getType() == 1 || hdr.getType() == 11 || hdr.getType() == 6)) {
            Message msg = (Message)evt.getArg();
            AuthHeader authHeader = new AuthHeader();
            authHeader.setToken(this.auth_plugin);
            msg.putHeader(this.id, authHeader);
        }
        return this.down_prot.down(evt);
    }

    private static GMS.GmsHeader getGMSHeader(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(gms_id);
                if (obj == null || !(obj instanceof GMS.GmsHeader)) {
                    return null;
                }
                return (GMS.GmsHeader)obj;
            }
        }
        return null;
    }
}

