/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Unsupported;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.STOMP;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class StompConnection
implements Runnable {
    protected Socket sock;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected final Set<String> server_destinations = new HashSet<String>();
    protected final Set<Listener> listeners = new HashSet<Listener>();
    protected final Set<String> subscriptions = new HashSet<String>();
    protected Thread runner;
    protected volatile boolean running = true;
    protected String session_id;
    protected final Log log = LogFactory.getLog(this.getClass());

    public StompConnection(String dest) {
        this.server_destinations.add(dest);
    }

    public String getSessionId() {
        return this.session_id;
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void connect(String userid, String password) throws IOException {
        String dest;
        if (this.isConnected()) {
            return;
        }
        while ((dest = this.pickRandomDestination()) != null) {
            try {
                this.connect(dest);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("connected to " + dest);
                break;
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed connecting to " + dest);
                }
                this.close();
                this.server_destinations.remove(dest);
            }
        }
        if (!this.isConnected()) {
            throw new IOException("no target server available");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(STOMP.ClientVerb.CONNECT.name()).append("\n");
        if (userid != null) {
            sb.append("login: ").append(userid).append("\n");
        }
        if (password != null) {
            sb.append("passcode: ").append(password).append("\n");
        }
        sb.append("\n");
        this.out.write(sb.toString().getBytes());
        this.out.write(0);
        this.out.flush();
    }

    public void reconnect() throws IOException {
        if (!this.running) {
            return;
        }
        this.connect();
        for (String subscription : this.subscriptions) {
            this.subscribe(subscription);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reconnected to " + this.sock.getInetAddress().getHostAddress() + ":" + this.sock.getPort());
            if (!this.subscriptions.isEmpty()) {
                this.log.debug("re-subscribed to " + this.subscriptions);
            }
        }
    }

    public void connect() throws IOException {
        this.connect(null, null);
    }

    public void disconnect() {
        this.running = false;
        this.close();
    }

    public void subscribe(String destination) {
        if (destination == null) {
            return;
        }
        this.subscriptions.add(destination);
        StringBuilder sb = new StringBuilder();
        sb.append(STOMP.ClientVerb.SUBSCRIBE.name()).append("\n");
        sb.append("destination: ").append(destination).append("\n");
        sb.append("\n");
        try {
            this.out.write(sb.toString().getBytes());
            this.out.write(0);
            this.out.flush();
        }
        catch (IOException ex) {
            this.log.error("failed subscribing to " + destination + ": " + ex);
        }
    }

    public void unsubscribe(String destination) {
        if (destination == null) {
            return;
        }
        this.subscriptions.remove(destination);
        StringBuilder sb = new StringBuilder();
        sb.append(STOMP.ClientVerb.UNSUBSCRIBE.name()).append("\n");
        sb.append("destination: ").append(destination).append("\n");
        sb.append("\n");
        try {
            this.out.write(sb.toString().getBytes());
            this.out.write(0);
            this.out.flush();
        }
        catch (IOException ex) {
            this.log.error("failed unsubscribing from " + destination + ": " + ex);
        }
    }

    public void send(String destination, byte[] buf, int offset, int length, String ... headers) {
        StringBuilder sb = new StringBuilder();
        sb.append(STOMP.ClientVerb.SEND.name()).append("\n");
        if (destination != null) {
            sb.append("destination: ").append(destination).append("\n");
        }
        if (buf != null) {
            sb.append("content-length: ").append(length).append("\n");
        }
        if (headers != null && headers.length % 2 == 0) {
            for (int i = 0; i < headers.length; ++i) {
                sb.append(headers[i]).append(": ").append(headers[++i]).append("\n");
            }
        }
        sb.append("\n");
        try {
            this.out.write(sb.toString().getBytes());
            if (buf != null) {
                this.out.write(buf, offset, length);
            }
            this.out.write(0);
            this.out.flush();
        }
        catch (IOException ex) {
            this.log.error("failed sending message to server: " + ex);
        }
    }

    public void send(String destination, String ... headers) {
        this.send(destination, null, 0, 0, headers);
    }

    public void send(String destination, byte[] buf, int offset, int length) {
        this.send(destination, buf, offset, length, (String[])null);
    }

    public void send(String destination, byte[] buf) {
        this.send(destination, buf, 0, buf.length);
    }

    @Override
    public void run() {
        block12: while (this.isConnected() && this.running) {
            try {
                STOMP.Frame frame = STOMP.readFrame(this.in);
                if (frame == null) continue;
                STOMP.ServerVerb verb = STOMP.ServerVerb.valueOf(frame.getVerb());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("frame: " + frame);
                }
                switch (verb) {
                    case MESSAGE: {
                        byte[] buf = frame.getBody();
                        this.notifyListeners(frame.getHeaders(), buf, 0, buf != null ? buf.length : 0);
                        break;
                    }
                    case CONNECTED: {
                        String sess_id = frame.getHeaders().get("session-id");
                        if (sess_id == null) continue block12;
                        this.session_id = sess_id;
                        break;
                    }
                    case ERROR: {
                        break;
                    }
                    case INFO: {
                        boolean changed;
                        List<String> list;
                        this.notifyListeners(frame.getHeaders());
                        String endpoints = frame.getHeaders().get("endpoints");
                        if (endpoints == null || (list = Util.parseCommaDelimitedStrings(endpoints)) == null || !(changed = this.server_destinations.addAll(list)) || !this.log.isDebugEnabled()) continue block12;
                        this.log.debug("INFO: new server target list: " + this.server_destinations);
                        break;
                    }
                    case RECEIPT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("verb " + (Object)((Object)verb) + " is not known");
                    }
                }
            }
            catch (IOException e) {
                this.close();
                try {
                    this.reconnect();
                }
                catch (IOException e1) {
                    this.log.warn("failed to reconnect; runner thread terminated, cause: " + e1);
                }
            }
            catch (Throwable t) {
                this.log.error("failure reading frame", t);
            }
        }
    }

    protected void notifyListeners(Map<String, String> headers, byte[] buf, int offset, int length) {
        for (Listener listener : this.listeners) {
            try {
                listener.onMessage(headers, buf, offset, length);
            }
            catch (Throwable t) {
                this.log.error("failed calling listener", t);
            }
        }
    }

    protected void notifyListeners(Map<String, String> info) {
        for (Listener listener : this.listeners) {
            try {
                listener.onInfo(info);
            }
            catch (Throwable t) {
                this.log.error("failed calling listener", t);
            }
        }
    }

    protected String pickRandomDestination() {
        return this.server_destinations.isEmpty() ? null : this.server_destinations.iterator().next();
    }

    protected void connect(String dest) throws IOException {
        SocketAddress saddr = StompConnection.parse(dest);
        this.sock = new Socket();
        this.sock.connect(saddr);
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new DataOutputStream(this.sock.getOutputStream());
        this.startRunner();
    }

    protected static SocketAddress parse(String dest) throws UnknownHostException {
        int index = dest.lastIndexOf(":");
        String host = dest.substring(0, index);
        int port = Integer.parseInt(dest.substring(index + 1));
        return new InetSocketAddress(host, port);
    }

    protected void close() {
        Util.close(this.in);
        Util.close(this.out);
        Util.close(this.sock);
    }

    public boolean isConnected() {
        return this.sock != null && this.sock.isConnected() && !this.sock.isClosed();
    }

    protected synchronized void startRunner() {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread((Runnable)this, "StompConnection receiver");
            this.runner.start();
        }
    }

    public static void main(String[] args) throws IOException {
        String host = "localhost";
        String port = "8787";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-p")) {
                port = args[++i];
                continue;
            }
            System.out.println("StompConnection [-h host] [-p port]");
            return;
        }
        StompConnection conn = new StompConnection(host + ":" + port);
        conn.addListener(new Listener(){

            @Override
            public void onMessage(Map<String, String> headers, byte[] buf, int offset, int length) {
                System.out.println("<< " + new String(buf, offset, length) + ", headers: " + headers);
            }

            @Override
            public void onInfo(Map<String, String> information) {
                System.out.println("<< INFO: " + information);
            }
        });
        conn.connect();
        while (conn.isConnected()) {
            try {
                String dest;
                String line = Util.readStringFromStdin(": ");
                if (line.startsWith("subscribe")) {
                    dest = line.substring("subscribe".length()).trim();
                    conn.subscribe(dest);
                    continue;
                }
                if (line.startsWith("unsubscribe")) {
                    dest = line.substring("unsubscribe".length()).trim();
                    conn.unsubscribe(dest);
                    continue;
                }
                if (line.startsWith("send")) {
                    String rest = line.substring("send".length()).trim();
                    int index = rest.indexOf(32);
                    if (index == -1) continue;
                    String dest2 = rest.substring(0, index);
                    String body = rest.substring(index + 1);
                    byte[] buf = body.getBytes();
                    conn.send(dest2, buf, 0, buf.length);
                    continue;
                }
                if (!line.startsWith("disconnect")) continue;
                conn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface Listener {
        public void onMessage(Map<String, String> var1, byte[] var2, int var3, int var4);

        public void onInfo(Map<String, String> var1);
    }
}

