/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ConcreteResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.ProxyControllerRegistration;

final class NodeSubregistry {
    private final String keyName;
    private final ConcreteResourceRegistration parent;
    private volatile Map<String, AbstractResourceRegistration> childRegistries;
    private static final AtomicMapFieldUpdater<NodeSubregistry, String, AbstractResourceRegistration> childRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(NodeSubregistry.class, Map.class, "childRegistries"));

    NodeSubregistry(String keyName, ConcreteResourceRegistration parent) {
        this.keyName = keyName;
        this.parent = parent;
        childRegistriesUpdater.clear(this);
    }

    AbstractResourceRegistration getParent() {
        return this.parent;
    }

    Set<String> getChildNames() {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        if (snapshot == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(snapshot.keySet());
    }

    ManagementResourceRegistration register(String elementValue, DescriptionProvider provider, boolean runtimeOnly) {
        ConcreteResourceRegistration newRegistry = new ConcreteResourceRegistration(elementValue, this, provider, runtimeOnly);
        this.register(elementValue, newRegistry);
        return newRegistry;
    }

    void register(String elementValue, ManagementResourceRegistration subModel) {
        AbstractResourceRegistration appearingRegistry;
        AbstractResourceRegistration newRegistry = null;
        if (subModel instanceof AbstractResourceRegistration) {
            newRegistry = (AbstractResourceRegistration)subModel;
        }
        if ((appearingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry)) != null) {
            throw new IllegalArgumentException("A node is already registered at '" + this.getLocationString() + elementValue + ")'");
        }
    }

    ProxyControllerRegistration registerProxyController(String elementValue, ProxyController proxyController) {
        ProxyControllerRegistration newRegistry = new ProxyControllerRegistration(elementValue, this, proxyController);
        AbstractResourceRegistration appearingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        if (appearingRegistry != null) {
            throw new IllegalArgumentException("A node is already registered at '" + this.getLocationString() + elementValue + ")'");
        }
        return newRegistry;
    }

    void unregisterProxyController(String elementValue) {
        childRegistriesUpdater.remove(this, elementValue);
    }

    OperationStepHandler getOperationHandler(ListIterator<PathElement> iterator, String child, String operationName, OperationStepHandler inherited) {
        Map<String, AbstractResourceRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getOperationHandler(iterator, operationName, inherited);
        }
        AbstractResourceRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getOperationHandler(iterator, operationName, inherited);
        }
        return null;
    }

    void getHandlers(ListIterator<PathElement> iterator, String child, Map<String, OperationEntry> providers, boolean inherited) {
        Map<String, AbstractResourceRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        AbstractResourceRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry == null) {
            if (childRegistry == null) {
                return;
            }
            childRegistry.getOperationDescriptions(iterator, providers, inherited);
            return;
        }
        if (childRegistry == null) {
            wildcardRegistry.getOperationDescriptions(iterator, providers, inherited);
            return;
        }
        wildcardRegistry.getOperationDescriptions(iterator, providers, inherited);
        childRegistry.getOperationDescriptions(iterator, providers, inherited);
    }

    String getLocationString() {
        return this.parent.getLocationString() + "(" + this.keyName + " => ";
    }

    DescriptionProvider getOperationDescription(Iterator<PathElement> iterator, String child, String operationName, DescriptionProvider inherited) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getOperationDescription(iterator, operationName, inherited);
        }
        AbstractResourceRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getOperationDescription(iterator, operationName, inherited);
        }
        return null;
    }

    Set<OperationEntry.Flag> getOperationFlags(ListIterator<PathElement> iterator, String child, String operationName, Set<OperationEntry.Flag> inherited) {
        Map<String, AbstractResourceRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getOperationFlags(iterator, operationName, inherited);
        }
        AbstractResourceRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getOperationFlags(iterator, operationName, inherited);
        }
        return null;
    }

    DescriptionProvider getModelDescription(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getModelDescription(iterator);
    }

    Set<String> getChildNames(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getChildNames(iterator);
    }

    Set<String> getAttributeNames(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getAttributeNames(iterator);
    }

    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String child, String attributeName) {
        Map<String, AbstractResourceRegistration> snapshot = childRegistriesUpdater.get(this);
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry != null) {
            return childRegistry.getAttributeAccess(iterator, attributeName);
        }
        AbstractResourceRegistration wildcardRegistry = snapshot.get("*");
        if (wildcardRegistry != null) {
            return wildcardRegistry.getAttributeAccess(iterator, attributeName);
        }
        return null;
    }

    Set<PathElement> getChildAddresses(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getChildAddresses(iterator);
    }

    ProxyController getProxyController(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null) {
            return null;
        }
        return childRegistry.getProxyController(iterator);
    }

    ManagementResourceRegistration getResourceRegistration(Iterator<PathElement> iterator, String child) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        AbstractResourceRegistration childRegistry = snapshot.get(child);
        if (childRegistry == null && (childRegistry = snapshot.get("*")) == null) {
            return null;
        }
        return childRegistry.getResourceRegistration(iterator);
    }

    void getProxyControllers(Iterator<PathElement> iterator, String child, Set<ProxyController> controllers) {
        Map<String, AbstractResourceRegistration> snapshot = this.childRegistries;
        if (child != null) {
            AbstractResourceRegistration childRegistry = snapshot.get(child);
            if (childRegistry == null) {
                return;
            }
            childRegistry.getProxyControllers(iterator, controllers);
        } else {
            for (AbstractResourceRegistration childRegistry : snapshot.values()) {
                childRegistry.getProxyControllers(iterator, controllers);
            }
        }
    }
}

