/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    WEBSERVICES_1_0("urn:jboss:domain:webservices:1.0"),
    JAVAEE("http://java.sun.com/xml/ns/javaee"),
    JAXWSCONFIG("urn:jboss:jbossws-jaxws-config:4.0");

    static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    String getUriString() {
        return this.name;
    }

    static {
        CURRENT = WEBSERVICES_1_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

