/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.publish.EndpointPublisherImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class ModelDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        DeploymentUnit unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class);
        if (!(unit instanceof EndpointPublisherImpl.WSEndpointDeploymentUnit)) {
            for (Endpoint endpoint : dep.getService().getEndpoints()) {
                ModelNode op = null;
                try {
                    op = unit.createDeploymentSubModel("webservices", PathElement.pathElement((String)"endpoint", (String)URLEncoder.encode(this.getId(endpoint), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                op.get("name").set(this.getName(endpoint));
                op.get("context").set(this.getContext(endpoint));
                op.get("class").set(endpoint.getTargetBeanName());
                op.get("type").set(this.getType(endpoint));
                op.get("wsdl-url").set(endpoint.getAddress() + "?wsdl");
            }
        }
    }

    public void stop(Deployment dep) {
    }

    private String getType(Endpoint endpoint) {
        return endpoint.getService().getDeployment().getType().toString();
    }

    private String getName(Endpoint endpoint) {
        return endpoint.getName().getKeyProperty("endpoint");
    }

    private String getContext(Endpoint endpoint) {
        return endpoint.getName().getKeyProperty("context");
    }

    private String getId(Endpoint endpoint) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContext(endpoint));
        sb.append(':');
        sb.append(this.getName(endpoint));
        return sb.toString();
    }
}

