/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.as.web.session.ClusteredSession;
import org.jboss.as.web.session.SessionManager;
import org.jboss.logging.Logger;

public class JvmRouteValve
extends ValveBase
implements Lifecycle {
    private static final String info = "JvmRouteValve/1.0";
    protected static Logger log_ = Logger.getLogger(JvmRouteValve.class);
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected SessionManager manager;

    public JvmRouteValve(SessionManager manager) {
        this.manager = manager;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.checkJvmRoute(request, response);
        this.getNext().invoke(request, response);
    }

    public void checkJvmRoute(Request req, Response res) throws IOException, ServletException {
        String requestedId = req.getRequestedSessionId();
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager.getJvmRoute();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("checkJvmRoute(): check if need to re-route based on JvmRoute. Session id: " + sessionId + " jvmRoute: " + jvmRoute));
            }
            if (jvmRoute != null) {
                boolean setCookie = !req.isRequestedSessionIdFromURL();
                this.handleJvmRoute(requestedId, sessionId, jvmRoute, (HttpServletResponse)res, setCookie);
            }
        }
    }

    protected void handleJvmRoute(String requestedId, String sessionId, String jvmRoute, HttpServletResponse response, boolean setCookie) throws IOException {
        String newId = null;
        Map.Entry<String, String> sessionEntry = this.manager.parse(sessionId);
        String realId = sessionEntry.getKey();
        String sessionJvmRoute = sessionEntry.getValue();
        if (sessionJvmRoute == null) {
            newId = this.manager.createSessionId(realId, jvmRoute);
        } else if (!jvmRoute.equals(sessionJvmRoute)) {
            if (log_.isTraceEnabled()) {
                log_.tracef("handleJvmRoute(): We have detected a failover with different jvmRoute. old one: %s, new one: %s. Will reset the session id.", (Object)sessionJvmRoute, (Object)jvmRoute);
            }
            newId = this.manager.createSessionId(realId, this.manager.locate(realId));
        }
        if (newId != null) {
            this.resetSessionId(sessionId, newId);
        }
        if (setCookie) {
            if (newId == null) {
                String requestedJvmRoute;
                String string = requestedJvmRoute = requestedId != null ? this.manager.parse(requestedId).getValue() : null;
                if (!jvmRoute.equals(requestedJvmRoute)) {
                    if (log_.isTraceEnabled()) {
                        log_.tracef("handleJvmRoute(): We have detected a failover with different jvmRoute. received one: %s, new one: %s. Will reset the session id.", (Object)requestedJvmRoute, (Object)jvmRoute);
                    }
                    newId = this.manager.createSessionId(realId, this.manager.locate(realId));
                }
            }
            if (newId != null) {
                this.manager.setNewSessionCookie(newId, response);
            }
        }
    }

    private void resetSessionId(String oldId, String newId) throws IOException {
        ClusteredSession session = (ClusteredSession)this.manager.findSession(oldId);
        if (session != null) {
            session.resetIdWithRouteInfo(newId);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("resetSessionId(): changed catalina session to= [" + newId + "] old one= [" + oldId + "]"));
            }
        } else if (log_.isTraceEnabled()) {
            log_.trace((Object)("resetSessionId(): no session with id " + newId + " found"));
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }
}

