/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;

public class TimerServiceRegistry {
    private static final Map<String, TimerServiceImpl> timerServices = new ConcurrentHashMap<String, TimerServiceImpl>();

    public static void registerTimerService(TimerServiceImpl timerservice) {
        if (timerservice == null) {
            throw new IllegalArgumentException("null timerservice cannot be registered");
        }
        String timedObjectId = timerservice.getInvoker().getTimedObjectId();
        if (timerServices.containsKey(timedObjectId)) {
            throw new IllegalStateException("Timer service with timedObjectId: " + timedObjectId + " is already registered");
        }
        timerServices.put(timedObjectId, timerservice);
    }

    public static TimerServiceImpl getTimerService(String timedObjectId) {
        return timerServices.get(timedObjectId);
    }

    public static boolean isRegistered(String timedObjectId) {
        return timerServices.containsKey(timedObjectId);
    }

    public static void unregisterTimerService(String timedObjectId) {
        if (timedObjectId == null) {
            throw new IllegalArgumentException("null timedObjectId cannot be used for unregistering timerservice");
        }
        if (!TimerServiceRegistry.isRegistered(timedObjectId)) {
            throw new IllegalArgumentException("Cannot unregister timer service with timedObjectId: " + timedObjectId + " because it's not registered");
        }
        timerServices.remove(timedObjectId);
    }
}

