/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanResultImpl;
import org.jboss.dmr.ModelNode;

class DomainDeploymentPlanResultFuture
implements Future<DeploymentPlanResult> {
    private final Future<ModelNode> nodeFuture;
    private final DeploymentPlanImpl plan;
    private final Map<UUID, String> actionsById;

    DomainDeploymentPlanResultFuture(DeploymentPlanImpl plan, Future<ModelNode> nodeFuture, Map<UUID, String> actionsById) {
        this.plan = plan;
        this.nodeFuture = nodeFuture;
        this.actionsById = actionsById;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.nodeFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.nodeFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.nodeFuture.isDone();
    }

    @Override
    public DeploymentPlanResult get() throws InterruptedException, ExecutionException {
        ModelNode node = this.nodeFuture.get();
        return this.getResultFromNode(node);
    }

    @Override
    public DeploymentPlanResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ModelNode node = this.nodeFuture.get(timeout, unit);
        return this.getResultFromNode(node);
    }

    private DeploymentPlanResult getResultFromNode(ModelNode planResultNode) {
        HashMap<UUID, DeploymentActionResult> actionResults = new HashMap<UUID, DeploymentActionResult>();
        String outcome = planResultNode.get("outcome").asString();
        if ("cancelled".equals(outcome)) {
            this.createCancelledResults(actionResults);
        } else if ("success".equals(outcome)) {
            this.createSuccessResults(actionResults, planResultNode);
        } else {
            this.createFailureResults(actionResults, planResultNode);
        }
        return new DeploymentPlanResultImpl((DeploymentPlan)this.plan, actionResults);
    }

    private void createFailureResults(Map<UUID, DeploymentActionResult> actionResults, ModelNode planResultNode) {
    }

    private void createSuccessResults(Map<UUID, DeploymentActionResult> actionResults, ModelNode planResultNode) {
    }

    private void createCancelledResults(Map<UUID, DeploymentActionResult> actionResults) {
    }
}

