/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain;

import org.jboss.as.controller.client.helpers.domain.InvalidDeploymentPlanException;

public class IncompleteDeploymentReplaceException
extends InvalidDeploymentPlanException {
    private static final long serialVersionUID = -8322852398826927588L;

    public IncompleteDeploymentReplaceException(String deploymentName, String ... missingGroups) {
        super(IncompleteDeploymentReplaceException.createMessage(deploymentName, missingGroups));
    }

    private static String createMessage(String deploymentName, String[] missingGroups) {
        StringBuilder sb = new StringBuilder("Only one version of deployment with a given unique name can exist in the domain. The deployment plan specified that a new version of deployment ");
        sb.append(deploymentName);
        sb.append(" replace an existing deployment with the same unique name, but did not apply the replacement to all server groups. Missing server groups were: ");
        for (int i = 0; i < missingGroups.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(missingGroups[i]);
        }
        return sb.toString();
    }
}

