/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.StandardSocketOption;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SocketAddressBuffer;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.AbstractNioChannelThread;
import org.xnio.nio.AbstractNioStreamChannel;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioXnio;
import org.xnio.nio.SelectorUtils;

class NioUdpChannel
implements MulticastMessageChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.udp.server.channel");
    private final NioXnio nioXnio;
    private volatile NioHandle<AbstractNioStreamChannel> readHandle;
    private volatile NioHandle<AbstractNioStreamChannel> writeHandle;
    private static final AtomicReferenceFieldUpdater<NioUdpChannel, NioHandle<NioUdpChannel>> readHandleUpdater = NioUdpChannel.unsafeUpdater(NioHandle.class, "readHandle");
    private static final AtomicReferenceFieldUpdater<NioUdpChannel, NioHandle<NioUdpChannel>> writeHandleUpdater = NioUdpChannel.unsafeUpdater(NioHandle.class, "writeHandle");
    private final NioSetter<NioUdpChannel> readSetter = new NioSetter();
    private final NioSetter<NioUdpChannel> writeSetter = new NioSetter();
    private final NioSetter<NioUdpChannel> closeSetter = new NioSetter();
    private final DatagramChannel datagramChannel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.BROADCAST).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.IP_TRAFFIC_CLASS).create();

    private static <T> AtomicReferenceFieldUpdater<NioUdpChannel, T> unsafeUpdater(Class<?> clazz, String name) {
        return AtomicReferenceFieldUpdater.newUpdater(NioUdpChannel.class, clazz, name);
    }

    NioUdpChannel(NioXnio nioXnio, DatagramChannel datagramChannel) {
        this.nioXnio = nioXnio;
        this.datagramChannel = datagramChannel;
    }

    public SocketAddress getLocalAddress() {
        return this.datagramChannel.socket().getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)(type.isInstance(this.getLocalAddress()) ? (SocketAddress)type.cast(this.getLocalAddress()) : null);
    }

    public int receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer buffer) throws IOException {
        int o = buffer.remaining();
        SocketAddress sourceAddress = this.datagramChannel.receive(buffer);
        if (sourceAddress == null) {
            return 0;
        }
        int t = o - buffer.remaining();
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers) throws IOException {
        return this.receiveFrom(addressBuffer, buffers, 0, buffers.length);
    }

    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers, int offs, int len) throws IOException {
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.receiveFrom(addressBuffer, buffers[offs]);
        }
        int o = (int)Math.min(Buffers.remaining((Buffer[])buffers, (int)offs, (int)len), 65536L);
        ByteBuffer buffer = ByteBuffer.allocate(o);
        SocketAddress sourceAddress = this.datagramChannel.receive(buffer);
        if (sourceAddress == null) {
            return 0L;
        }
        int t = o - buffer.remaining();
        buffer.flip();
        Buffers.copy((ByteBuffer[])buffers, (int)offs, (int)len, (ByteBuffer)buffer);
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    public boolean sendTo(SocketAddress target, ByteBuffer buffer) throws IOException {
        return this.datagramChannel.send(buffer, target) != 0;
    }

    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers) throws IOException {
        return this.sendTo(target, buffers, 0, buffers.length);
    }

    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers, int offset, int length) throws IOException {
        if (length == 0) {
            return false;
        }
        if (length == 1) {
            return this.sendTo(target, buffers[offset]);
        }
        long o = Buffers.remaining((Buffer[])buffers, (int)offset, (int)length);
        if (o > 65535L) {
            throw new IllegalArgumentException("Too may bytes written");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)o);
        Buffers.copy((ByteBuffer)buffer, (ByteBuffer[])buffers, (int)offset, (int)length);
        buffer.flip();
        return this.datagramChannel.send(buffer, target) != 0;
    }

    public final void setReadThread(ReadChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<NioUdpChannel> newHandle = thread == null ? null : ((AbstractNioChannelThread)thread).addChannel(this.datagramChannel, this, 1, this.readSetter);
            NioHandle oldValue = readHandleUpdater.getAndSet(this, newHandle);
            if (oldValue != null) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public ReadChannelThread getReadThread() {
        NioHandle<NioUdpChannel> handle = readHandleUpdater.get(this);
        return handle == null ? null : (ReadChannelThread)handle.getChannelThread();
    }

    public final void setWriteThread(WriteChannelThread thread) throws IllegalArgumentException {
        try {
            NioHandle<NioUdpChannel> newHandle = thread == null ? null : ((AbstractNioChannelThread)thread).addChannel(this.datagramChannel, this, 4, this.writeSetter);
            NioHandle oldValue = writeHandleUpdater.getAndSet(this, newHandle);
            if (oldValue != null) {
                oldValue.cancelKey();
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Thread belongs to the wrong provider");
        }
    }

    public WriteChannelThread getWriteThread() {
        NioHandle<NioUdpChannel> handle = writeHandleUpdater.get(this);
        return handle == null ? null : (WriteChannelThread)handle.getChannelThread();
    }

    public ChannelListener.Setter<NioUdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            log.tracef("Closing %s", (Object)this);
            try {
                this.datagramChannel.close();
            }
            finally {
                this.cancelKeys();
                ChannelListeners.invokeChannelListener((Channel)((Object)this), this.closeSetter.get());
            }
        }
    }

    private void cancelKeys() {
        NioHandle readHandle = readHandleUpdater.getAndSet(this, null);
        NioHandle writeHandle = writeHandleUpdater.getAndSet(this, null);
        if (readHandle != null) {
            readHandle.cancelKey();
        }
        if (writeHandle != null) {
            writeHandle.cancelKey();
        }
    }

    public void suspendReads() {
        try {
            this.readHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.writeHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.readHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.writeHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    public boolean shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.datagramChannel, 4, time, timeUnit);
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface));
    }

    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface, source));
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return (T)option.cast((Object)socket.getSendBufferSize());
        }
        if (option == Options.BROADCAST) {
            return (T)option.cast((Object)socket.getBroadcast());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return (T)option.cast((Object)socket.getTrafficClass());
        }
        if (NioXnio.NIO2) {
            if (option == Options.MULTICAST_TTL) {
                return (T)option.cast(channel.getOption(StandardSocketOption.IP_MULTICAST_TTL));
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Object old;
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            old = socket.getReceiveBufferSize();
            socket.setReceiveBufferSize((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.SEND_BUFFER) {
            old = socket.getSendBufferSize();
            socket.setSendBufferSize((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            old = socket.getTrafficClass();
            socket.setTrafficClass((Integer)value);
            return (T)option.cast(old);
        } else if (option == Options.BROADCAST) {
            old = socket.getBroadcast();
            socket.setBroadcast((Boolean)value);
            return (T)option.cast(old);
        } else {
            if (!NioXnio.NIO2) return null;
            if (option != Options.MULTICAST_TTL) return null;
            old = option.cast(channel.getOption(StandardSocketOption.IP_MULTICAST_TTL));
            channel.setOption(StandardSocketOption.IP_MULTICAST_TTL, (Integer)value);
        }
        return (T)option.cast(old);
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%h>", this);
    }

    class NioKey
    implements MulticastMessageChannel.Key {
        private final MembershipKey key;

        NioKey(MembershipKey key) {
            this.key = key;
        }

        public MulticastMessageChannel.Key block(InetAddress source) throws IOException, UnsupportedOperationException, IllegalStateException, IllegalArgumentException {
            this.key.block(source);
            return this;
        }

        public MulticastMessageChannel.Key unblock(InetAddress source) throws IOException, IllegalStateException, UnsupportedOperationException {
            this.key.unblock(source);
            return this;
        }

        public MulticastMessageChannel getChannel() {
            return NioUdpChannel.this;
        }

        public InetAddress getGroup() {
            return this.key.group();
        }

        public NetworkInterface getNetworkInterface() {
            return this.key.networkInterface();
        }

        public InetAddress getSourceAddress() {
            return this.key.sourceAddress();
        }

        public boolean isOpen() {
            return this.key.isValid();
        }

        public void close() throws IOException {
            this.key.drop();
        }
    }
}

