/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class StrictMaxPoolAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final StrictMaxPoolAdd INSTANCE = new StrictMaxPoolAdd();

    public ModelNode getModelDescription(Locale locale) {
        return EJB3SubsystemDescriptions.getStrictMaxPoolAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode strictMaxPoolModel) throws OperationFailedException {
        String poolName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        strictMaxPoolModel.get("name").set(poolName);
        if (operation.hasDefined("max-pool-size")) {
            int maxPoolSize = operation.get("max-pool-size").asInt();
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("Invalid value: " + maxPoolSize + " for " + "max-pool-size");
            }
            strictMaxPoolModel.get("max-pool-size").set(maxPoolSize);
        }
        if (operation.hasDefined("timeout")) {
            long instanceAcquisitionTimeout = operation.get("timeout").asLong();
            if (instanceAcquisitionTimeout <= 0L) {
                throw new IllegalArgumentException("Invalid value: " + instanceAcquisitionTimeout + " for " + "timeout");
            }
            strictMaxPoolModel.get("timeout").set(instanceAcquisitionTimeout);
        }
        if (operation.hasDefined("timeout-unit")) {
            String instanceAcquisitionTimeoutUnit = operation.get("timeout-unit").asString();
            if (!this.isValidTimeoutUnit(instanceAcquisitionTimeoutUnit)) {
                throw new IllegalArgumentException("Invalid value: " + instanceAcquisitionTimeoutUnit + " for " + "timeout-unit");
            }
            strictMaxPoolModel.get("timeout-unit").set(instanceAcquisitionTimeoutUnit.trim().toUpperCase(Locale.ENGLISH));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode strictMaxPoolModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        String poolName = strictMaxPoolModel.require("name").asString();
        int maxPoolSize = strictMaxPoolModel.get("max-pool-size").asInt(20);
        long timeout = strictMaxPoolModel.get("timeout").asLong(5L);
        String unit = strictMaxPoolModel.hasDefined("timeout-unit") ? strictMaxPoolModel.get("timeout-unit").asString() : StrictMaxPoolConfig.DEFAULT_TIMEOUT_UNIT.name();
        StrictMaxPoolConfig strictMaxPoolConfig = new StrictMaxPoolConfig(poolName, maxPoolSize, timeout, TimeUnit.valueOf(unit));
        PoolConfigService poolConfigService = new PoolConfigService(strictMaxPoolConfig);
        ServiceName serviceName = PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName});
        ServiceController serviceController = context.getServiceTarget().addService(serviceName, (Service)poolConfigService).install();
        serviceControllers.add(serviceController);
    }

    private boolean isValidTimeoutUnit(String val) {
        if (val == null || val.trim().isEmpty()) {
            return false;
        }
        String upperCaseUnitValue = val.toUpperCase(Locale.ENGLISH);
        try {
            TimeUnit unit = TimeUnit.valueOf(upperCaseUnitValue);
            if (unit == TimeUnit.SECONDS || unit == TimeUnit.HOURS || unit == TimeUnit.MINUTES || unit == TimeUnit.MILLISECONDS) {
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return false;
    }
}

