/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.util.Set;
import javax.ejb.EJBAccessException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBMethodSecurityMetaData;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class AuthorizationInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(AuthorizationInterceptor.class);
    private final EJBMethodSecurityMetaData ejbMethodSecurityMetaData;
    private final String viewClassName;
    private final Method viewMethod;

    public AuthorizationInterceptor(EJBMethodSecurityMetaData ejbMethodSecurityMetaData, String viewClassName, Method viewMethod) {
        if (ejbMethodSecurityMetaData == null) {
            throw new IllegalArgumentException("EJB method security metadata cannot be null");
        }
        if (viewClassName == null || viewClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("View classname cannot be null or empty");
        }
        if (viewMethod == null) {
            throw new IllegalArgumentException("View method cannot be null");
        }
        this.ejbMethodSecurityMetaData = ejbMethodSecurityMetaData;
        this.viewClassName = viewClassName;
        this.viewMethod = viewMethod;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        SimpleSecurityManager securityManager;
        Set<String> allowedRoles;
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            throw new IllegalStateException("Unexpected component type: " + component.getClass() + " expected: " + EJBComponent.class);
        }
        Method invokedMethod = context.getMethod();
        ComponentViewInstance componentViewInstance = (ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class);
        String viewClassOfInvokedMethod = componentViewInstance.getViewClass().getName();
        if (!this.viewClassName.equals(viewClassOfInvokedMethod) || !this.viewMethod.equals(invokedMethod)) {
            throw new IllegalStateException(this.getClass().getName() + " cannot handle method " + invokedMethod + " of view class " + viewClassOfInvokedMethod + ".Expected view " + "method to be " + this.viewMethod + " on view class " + this.viewClassName);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        if (this.ejbMethodSecurityMetaData.isAccessDenied()) {
            throw new EJBAccessException("Invocation on method: " + invokedMethod + " of bean: " + ejbComponent.getComponentName() + " is not allowed");
        }
        if (!(this.ejbMethodSecurityMetaData.isPermitAll() || (allowedRoles = this.ejbMethodSecurityMetaData.getRolesAllowed()).isEmpty() || (securityManager = ejbComponent.getSecurityManager()).isCallerInRole(allowedRoles.toArray(new String[allowedRoles.size()])))) {
            throw new EJBAccessException("Invocation on method: " + invokedMethod + " of bean: " + ejbComponent.getComponentName() + " is not allowed");
        }
        return context.proceed();
    }
}

