/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;

public class MethodResolutionUtils {
    public static Method resolveMethod(NamedMethodMetaData methodData, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        for (Class<?> clazz = componentClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            Collection methods;
            ClassReflectionIndex classIndex = reflectionIndex.getClassIndex(clazz);
            if (methodData.getMethodParams() == null) {
                methods = classIndex.getAllMethods(methodData.getMethodName());
                if (methods.size() > 1) {
                    throw new DeploymentUnitProcessingException("More than one method " + methodData.getMethodName() + "found on class" + componentClass.getName() + " referenced in ejb-jar.xml. Specify the parameter types to resolve the ambiguity");
                }
                if (methods.size() != 1) continue;
                return (Method)methods.iterator().next();
            }
            methods = classIndex.getAllMethods(methodData.getMethodName(), methodData.getMethodParams().size());
            for (Method method : methods) {
                boolean match = true;
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    if (method.getParameterTypes()[i].getName().equals(methodData.getMethodParams().get(i))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return method;
            }
        }
        throw new DeploymentUnitProcessingException("Could not find method" + componentClass.getName() + "." + methodData.getMethodName() + " referenced in ejb-jar.xml");
    }
}

