/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.modules.Module;

public class MethodPermissionDDProcessor
extends AbstractEjbXmlDescriptorProcessor<EnterpriseBeanMetaData> {
    private static final Logger logger = Logger.getLogger(MethodPermissionDDProcessor.class);

    @Override
    protected Class<EnterpriseBeanMetaData> getMetaDataType() {
        return EnterpriseBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(EnterpriseBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class ejbClass;
        String ejbName = beanMetaData.getEjbName();
        AssemblyDescriptorMetaData assemblyDescriptor = beanMetaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        MethodPermissionsMetaData methodPermissions = assemblyDescriptor.getMethodPermissionsByEjbName(ejbName);
        if (methodPermissions == null || methodPermissions.isEmpty()) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)moduleDescription.getComponentByName(ejbName);
        try {
            ejbClass = module.getClassLoader().loadClass(beanMetaData.getEjbClass());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Could not load EJB class " + beanMetaData.getEjbClass());
        }
        ClassReflectionIndex classReflectionIndex = deploymentReflectionIndex.getClassIndex(ejbClass);
        for (MethodPermissionMetaData methodPermission : methodPermissions) {
            MethodsMetaData methods = methodPermission.getMethods();
            if (methods == null || methods.isEmpty() || methodPermission.isNotChecked()) continue;
            Set securityRoles = methodPermission.getRoles();
            for (MethodMetaData method : methods) {
                String methodName = method.getMethodName();
                MethodIntf methodIntf = this.getMethodIntf(method);
                if (methodName.equals("*")) {
                    if (methodIntf == null) {
                        ejbComponentDescription.setRolesAllowedForAllMethodsOfAllViews(securityRoles);
                        continue;
                    }
                    ejbComponentDescription.setRolesAllowedForAllMethodsOnViewType(methodIntf, securityRoles);
                    continue;
                }
                MethodParametersMetaData methodParams = method.getMethodParams();
                if (methodParams == null || methodParams.isEmpty()) {
                    Collection applicableMethods = ClassReflectionIndexUtil.findAllMethodsByName((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (String)methodName);
                    if (applicableMethods.isEmpty()) {
                        logger.warn((Object)("No method named: " + methodName + " found on EJB: " + ejbName + " while processing method-permission element in ejb-jar.xml"));
                        continue;
                    }
                    this.setRolesAllowed(ejbComponentDescription, methodIntf, applicableMethods, securityRoles);
                    continue;
                }
                String[] paramTypes = (String[])methodParams.toArray((Object[])new String[methodParams.size()]);
                Collection applicableMethods = ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (String)methodName, (String[])paramTypes);
                if (applicableMethods.isEmpty()) {
                    logger.warn((Object)("No method named: " + methodName + " with param types: " + paramTypes + " found on EJB: " + ejbName + " while processing method-permission element in ejb-jar.xml"));
                    continue;
                }
                this.setRolesAllowed(ejbComponentDescription, methodIntf, applicableMethods, securityRoles);
            }
        }
    }

    private MethodIntf getMethodIntf(MethodMetaData method) {
        MethodInterfaceType methodInterfaceType = method.getMethodIntf();
        if (methodInterfaceType == null) {
            return null;
        }
        switch (methodInterfaceType) {
            case Local: {
                return MethodIntf.LOCAL;
            }
            case Remote: {
                return MethodIntf.REMOTE;
            }
            case Home: {
                return MethodIntf.HOME;
            }
            case LocalHome: {
                return MethodIntf.LOCAL_HOME;
            }
            case ServiceEndpoint: {
                return MethodIntf.SERVICE_ENDPOINT;
            }
            case MessageEndpoint: {
                return MethodIntf.MESSAGE_ENDPOINT;
            }
            case Timer: {
                return MethodIntf.TIMER;
            }
        }
        throw new RuntimeException("Unknown method-intf " + methodInterfaceType + " on method " + method);
    }

    private void setRolesAllowed(EJBComponentDescription ejbComponentDescription, MethodIntf viewType, Collection<Method> rolesAllowedApplicableMethods, Collection<String> roles) {
        for (Method denyAllApplicableMethod : rolesAllowedApplicableMethods) {
            EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(denyAllApplicableMethod);
            if (viewType == null) {
                ejbComponentDescription.setRolesAllowedOnAllViewsForMethod(ejbMethodIdentifier, new HashSet<String>(roles));
                continue;
            }
            ejbComponentDescription.setRolesAllowedForMethodOnViewType(viewType, ejbMethodIdentifier, new HashSet<String>(roles));
        }
    }
}

