/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.util.id.GUID;

public class StatefulSessionComponentInstance
extends SessionBeanComponentInstance
implements Identifiable {
    private final GUID id = new GUID();
    private final Interceptor afterBegin;
    private final Interceptor afterCompletion;
    private final Interceptor beforeCompletion;
    private boolean isDiscarded = false;

    protected StatefulSessionComponentInstance(StatefulSessionComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        this.afterBegin = component.createInterceptor(component.afterBegin);
        this.afterCompletion = component.createInterceptor(component.afterCompletion);
        this.beforeCompletion = component.createInterceptor(component.beforeCompletion);
    }

    protected void afterBegin() {
        this.execute(this.afterBegin, new Object[0]);
    }

    protected void afterCompletion(boolean committed) {
        this.execute(this.afterCompletion, committed);
    }

    protected void beforeCompletion() {
        this.execute(this.beforeCompletion, new Object[0]);
    }

    protected void discard() {
        if (!this.isDiscarded) {
            this.isDiscarded = true;
            this.getComponent().getCache().discard((Serializable)this.id);
        }
    }

    protected Object execute(Interceptor interceptor, Object ... parameters) {
        if (interceptor == null) {
            return null;
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(InvokeMethodOnTargetInterceptor.PARAMETERS_KEY, (Object)parameters);
        try {
            return interceptor.processInvocation(interceptorContext);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public StatefulSessionComponent getComponent() {
        return (StatefulSessionComponent)super.getComponent();
    }

    @Override
    public Serializable getId() {
        return this.id;
    }
}

